/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.text;

import com.fabriziopolo.textcraft.simulation.Frame;

public interface TextMatcher {
    public Result matches(String[] var1, int var2, Frame var3);

    public static final class ResultWithData<T> {
        public final Result matcherResult;
        public final T data;

        private ResultWithData(Result matcherResult, T data) {
            this.matcherResult = matcherResult;
            this.data = data;
        }

        public boolean isMatch() {
            return this.matcherResult.isMatch;
        }

        public int getStartIndex() {
            return this.matcherResult.startIndex;
        }

        public int getEndIndex() {
            return this.matcherResult.getEndIndex();
        }

        public int getNumWordsMatched() {
            return this.matcherResult.numWordsMatched;
        }

        public static <U> ResultWithData createMatch(int startIdx, int length, U object) {
            return new ResultWithData<U>(Result.createMatch(startIdx, length), object);
        }

        public static <U> ResultWithData createMatch(Result result, U object) {
            return new ResultWithData<U>(result, object);
        }

        public static ResultWithData createFailed() {
            return new ResultWithData<Object>(Result.createFailed(), null);
        }
    }

    public static final class Result {
        public final boolean isMatch;
        public final int startIndex;
        public final int numWordsMatched;

        private Result(boolean isMatch, int startIndex, int numWordsMatched) {
            this.isMatch = isMatch;
            this.startIndex = startIndex;
            this.numWordsMatched = numWordsMatched;
        }

        public int getEndIndex() {
            return this.startIndex + this.numWordsMatched;
        }

        public static Result createFailed() {
            return new Result(false, 0, 0);
        }

        public static Result createMatch(int startIndex, int numWordsMatched) {
            return new Result(true, startIndex, numWordsMatched);
        }
    }
}

