/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.text;

import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.StringUtils;

public final class Text {
    private Text() {
    }

    public static Map<String, List<Noun>> groupNounsByDescriptionIntoMap(List<Noun> nouns, Perceiver perceiver, Frame frame) {
        HashMap<String, List<Noun>> groups = new HashMap<String, List<Noun>>();
        for (Noun noun : nouns) {
            NounPhrase np = perceiver.getPerceptionOf(noun, frame);
            if (np == null) continue;
            String descr = np.toString();
            if (!groups.containsKey(descr)) {
                groups.put(descr, new ArrayList());
            }
            ((List)groups.get(descr)).add(noun);
        }
        return groups;
    }

    public static Collection<List<Noun>> groupNounsByDescription(List<Noun> nouns, Perceiver perceiver, Frame frame) {
        return Text.groupNounsByDescriptionIntoMap(nouns, perceiver, frame).values();
    }

    public static List<Noun> chooseRepresentativesByDescription(List<Noun> nouns, Perceiver perceiver, Frame frame) {
        return Text.groupNounsByDescription(nouns, perceiver, frame).stream().map(list -> (Noun)list.get(0)).collect(Collectors.toList());
    }

    public static List<String> wrapToLines(int width, String text) {
        char[] chars = text.toCharArray();
        ArrayList<String> lines = new ArrayList<String>();
        int idx = 0;
        while (idx < chars.length) {
            if (chars[idx] == '\n') {
                lines.add("");
                ++idx;
                continue;
            }
            StringBuilder builder = new StringBuilder();
            int nextIdx = Text.findNextWrapPoint(chars, idx, width);
            for (int i = idx; i < nextIdx; ++i) {
                builder.append(chars[i]);
            }
            lines.add(builder.toString());
            idx = nextIdx + 1;
        }
        return lines;
    }

    public static String wrap(String leftMargin, String rightMargin, int width, String text) {
        int i;
        List<String> lines = Text.wrapToLines(width, text);
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            int rightMarginSize = Math.max(width - line.length() - 1, 0);
            lines.set(i, leftMargin + line + StringUtils.repeat(" ", rightMarginSize) + rightMargin);
        }
        for (i = 0; i < lines.size(); ++i) {
            String newLine = lines.get(i) + Text.getLineSeparator();
            lines.set(i, newLine);
        }
        for (String line : lines) {
            builder.append(line);
        }
        return builder.toString();
    }

    public static String wrap(int startColumn, int endColumn, String text) {
        return Text.wrap(StringUtils.repeat(" ", startColumn), "", endColumn - startColumn, text);
    }

    public static String displayValue(double value) {
        return new DecimalFormat("0.00;0.00").format(value);
    }

    public static String encodeFileName(String name) {
        String cleanName = name.replace('.', ' ').replace('~', ' ');
        return URLEncoder.encode(cleanName);
    }

    public static String decodeFileName(String name) {
        return URLDecoder.decode(name);
    }

    private static int findNextWrapPoint(char[] chars, int idx, int endColumn) {
        for (int i = idx + 1; i < idx + endColumn && i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            return i;
        }
        int prevWrapIdx = idx;
        int nextWrapIdx = idx;
        while ((nextWrapIdx = Text.findNextPotentialWrapPoint(chars, prevWrapIdx, endColumn)) - idx < endColumn && nextWrapIdx != chars.length) {
            prevWrapIdx = nextWrapIdx;
        }
        if (nextWrapIdx < idx + endColumn) {
            return nextWrapIdx;
        }
        if (prevWrapIdx == idx) {
            return Math.min(idx + endColumn, nextWrapIdx);
        }
        return prevWrapIdx;
    }

    private static int findNextPotentialWrapPoint(char[] chars, int idx, int width) {
        for (int i = idx + 1; i < chars.length; ++i) {
            if (!Text.charIsWrappable(chars[i])) continue;
            return i;
        }
        return chars.length;
    }

    private static boolean charIsWrappable(char c) {
        return Character.isWhitespace(c);
    }

    public static String connectWithSpaces(List<String> strings) {
        if (strings.size() == 0) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.size() - 1; ++i) {
            builder.append(strings.get(i));
            builder.append(" ");
        }
        builder.append(strings.get(strings.size() - 1));
        return builder.toString();
    }

    public static String toStringListWithAnd(List<String> strings) {
        if (strings.size() == 0) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        if (strings.size() == 2) {
            return strings.get(0) + " and " + strings.get(1);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.size() - 1; ++i) {
            builder.append(strings.get(i));
            builder.append(", ");
        }
        builder.append("and ");
        builder.append(strings.get(strings.size() - 1));
        return builder.toString();
    }

    static String toStringList(List<String> strings) {
        if (strings.size() == 0) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.size() - 1; ++i) {
            builder.append(strings.get(i));
            builder.append(", ");
        }
        builder.append(strings.get(strings.size() - 1));
        return builder.toString();
    }

    public static String[] parseIntoWords(String input) {
        return input.trim().split("\\s+");
    }

    public static String getLineSeparator() {
        return "\n";
    }
}

