/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.temperature;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueProvider;
import com.fabriziopolo.textcraft.states.ValueProviderState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilterState;
import com.fabriziopolo.textcraft.states.water.WaterState;
import com.fabriziopolo.textcraft.states.weather.WeatherState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import java.util.Set;

public class TemperatureState
extends ValueProviderState<FlexibleHeatUnit, Void> {
    @Override
    protected Class getStateKey() {
        return TemperatureState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        TemperatureState newState = new TemperatureState();
        this.setUpdatedState(simulation, newState);
        newState.setImmutable();
        return newState;
    }

    public static TemperatureState get(Frame frame) {
        return (TemperatureState)frame.states.get(TemperatureState.class);
    }

    public FlexibleHeatUnit getHeatProducedBy(Noun noun, Frame frame) {
        return (FlexibleHeatUnit)this.get(noun, null, frame);
    }

    public static FlexibleHeatUnit getTemperatureAt(Noun noun, Frame frame) {
        FlexibleHeatUnit heat = TemperatureState.getRoomTemperature(noun, frame).plus(WeatherState.getSunTemperatureAt(noun, frame)).plus(WeatherState.getRainTemperatureAt(noun, frame)).plus(WaterState.getWaterTemperatureAt(noun, frame));
        FlexibleHeatUnit filteredHeat = TemperatureFilterState.getTemperatureFilteredFromOutside(noun, heat, frame);
        return filteredHeat;
    }

    public static FlexibleHeatUnit getRoomTemperature(Noun noun, Frame frame) {
        PositionState position = PositionState.get(frame);
        Noun room = position.getContainingRoom(noun);
        if (room == null) {
            return FlexibleHeatUnit.createNeutral();
        }
        Set<Noun> allNouns = position.getDesendentsOf(room);
        allNouns.add(room);
        FlexibleHeatUnit roomTemp = WeatherState.getAirTemperatureAt(noun, frame);
        TemperatureState temperatureState = TemperatureState.get(frame);
        for (Noun obj : allNouns) {
            roomTemp = roomTemp.plus((FlexibleHeatUnit)temperatureState.get(obj, null, frame));
        }
        return roomTemp;
    }

    public static void requestSetHeatProvider(Simulation simulation, Noun noun, ValueProvider<FlexibleHeatUnit, Void> heatProvider) {
        TemperatureState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, heatProvider);
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(this.getStateKey());
        builder.addLine("heatProvider", this.get(noun));
        try {
            builder.addLine("heat", this.get(noun) == null ? null : ((ValueProvider)this.get(noun)).get(noun, null, frame));
        }
        catch (Exception ex) {
            builder.addLine("heat", "<FAILED TO GET VALUE>");
        }
        builder.addLine("temperatureAt", TemperatureState.getTemperatureAt(noun, frame));
        return builder.toString();
    }

    public static String getTemperatureDescription(double temp) {
        if (temp < 0.0) {
            return TemperatureState.getColdTemperatureDescription(-temp);
        }
        return TemperatureState.getHotTemperatureDescription(temp);
    }

    private static String getHotTemperatureDescription(double temp) {
        if (temp < 1.0) {
            return "comfortable";
        }
        if (temp < 2.0) {
            return "warm";
        }
        if (temp < 3.0) {
            return "hot";
        }
        if (temp < 4.0) {
            return "sweltering";
        }
        return "suffering from heat stroke";
    }

    private static String getColdTemperatureDescription(double temp) {
        if (temp < 1.0) {
            return "comfortable";
        }
        if (temp < 2.0) {
            return "cold";
        }
        if (temp < 3.0) {
            return "very cold";
        }
        if (temp < 4.0) {
            return "freezing";
        }
        return "suffering from hypothermia";
    }
}

