/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.singleplayer;

import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.BooleanWithCauseState;
import com.fabriziopolo.textcraft.states.ValueWithCauseState;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.text.Text;
import java.io.Serializable;

public class WaitState
extends BooleanWithCauseState {
    private static final NotificationKey NOTIFICATION_KEY = new NotificationKey(WaitState.class, "wait");

    @Override
    protected Class getStateKey() {
        return WaitState.class;
    }

    @Override
    protected String getNotificationMessage(Noun noun, ValueWithCauseState.ValueWithCause<Boolean> valueWithCause, Boolean prevValue, Simulation simulation) {
        if (((Boolean)valueWithCause.value).equals(prevValue)) {
            return null;
        }
        Sentences timeOfDayDescriptionSentences = TimeState.get(simulation.getCurrentFrame()).getTimeOfDayDescriptionSentences();
        if (((Boolean)valueWithCause.value).booleanValue()) {
            return "You " + this.getChangeDescription((Boolean)valueWithCause.value) + ".  " + timeOfDayDescriptionSentences + Text.getLineSeparator() + "...";
        }
        if (valueWithCause.causeDescription == null) {
            return "..." + Text.getLineSeparator() + "You " + this.getChangeDescription((Boolean)valueWithCause.value) + ".  " + timeOfDayDescriptionSentences;
        }
        return "..." + Text.getLineSeparator() + "You " + this.getChangeDescription((Boolean)valueWithCause.value) + " because " + valueWithCause.causeDescription + ".  " + timeOfDayDescriptionSentences;
    }

    @Override
    public State updateState(Simulation simulation) {
        WaitState newState = new WaitState();
        this.setUpdatedState(simulation, newState);
        newState.setImmutable();
        this.notifyNounsOfChangeCauses(simulation, newState);
        return newState;
    }

    public boolean isWaiting(Noun noun) {
        Serializable vwc = this.get(noun);
        if (vwc == null) {
            return false;
        }
        return (Boolean)((ValueWithCauseState.ValueWithCause)vwc).value;
    }

    @Override
    public ValueWithCauseState.ValueWithCause<Boolean> get(Noun noun) {
        return (ValueWithCauseState.ValueWithCause)super.get(noun);
    }

    public static WaitState get(Frame frame) {
        return (WaitState)frame.states.get(WaitState.class);
    }

    public static void requestWait(Noun noun, Simulation simulation) {
        WaitState.requestChange(noun, ValueWithCauseState.ValueWithCause.create(true), simulation);
    }

    public static void requestStopWaiting(Noun noun, Simulation simulation) {
        WaitState.requestChange(noun, ValueWithCauseState.ValueWithCause.create(false), simulation);
    }

    public static void requestStopWaiting(Noun noun, String cause, Simulation simulation) {
        WaitState.requestChange(noun, ValueWithCauseState.ValueWithCause.create(false, cause), simulation);
    }

    public static void requestChange(Noun noun, ValueWithCauseState.ValueWithCause<Boolean> vwc, Simulation simulation) {
        WaitState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, vwc);
    }

    @Override
    protected NotificationKey getNotificationKey() {
        return NOTIFICATION_KEY;
    }

    @Override
    protected int getNotificationRepeatRate() {
        return 60;
    }

    @Override
    protected int getNotificationTimeout() {
        return 2;
    }

    @Override
    protected String getChangeDescription(boolean value) {
        if (value) {
            return "wait patiently";
        }
        return "stop waiting";
    }
}

