/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.scenery;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.states.scenery.Scenery;

public class VisualScenery
implements Scenery {
    private final Scenery delegate;

    public VisualScenery(Scenery delegate) {
        this.delegate = delegate;
    }

    @Override
    public IndependentClause asPerceivedBy(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
        Coordinates perceiverCoordinates = CoordinateState.get(perceiver, frame);
        Coordinates sceneryCoordinates = CoordinateState.get(associatedNoun, frame);
        if (perceiverCoordinates == null || sceneryCoordinates == null) {
            return null;
        }
        if (perceiverCoordinates.distanceTo(sceneryCoordinates) < 2.0) {
            return null;
        }
        double yDiff = sceneryCoordinates.y - perceiverCoordinates.y;
        double xDiff = sceneryCoordinates.x - perceiverCoordinates.x;
        boolean isVisible = false;
        switch (direction.getContextFreeDescription().toString()) {
            case "north": {
                isVisible = yDiff < 0.0 && Math.abs(xDiff) <= Math.abs(yDiff);
                break;
            }
            case "south": {
                isVisible = yDiff > 0.0 && Math.abs(xDiff) <= yDiff;
                break;
            }
            case "east": {
                isVisible = xDiff > 0.0 && Math.abs(yDiff) <= xDiff;
                break;
            }
            case "west": {
                isVisible = xDiff < 0.0 && Math.abs(yDiff) <= Math.abs(xDiff);
            }
        }
        return isVisible ? this.delegate.asPerceivedBy(perceiver, direction, associatedNoun, channel, frame) : null;
    }

    @Override
    public double getPerceivedDistance(Noun noun1, Noun noun2, Frame frame) {
        return this.delegate.getPerceivedDistance(noun1, noun2, frame);
    }
}

