/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.scenery;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.states.scenery.Scenery;

public class RectLimitedScenery
implements Scenery {
    private final double width;
    private final double height;
    private final double innerWidth;
    private final double innerHeight;
    private final Scenery delegate;

    public RectLimitedScenery(double width, double height, Scenery delegate) {
        this(width, height, -1.0, -1.0, delegate);
    }

    public RectLimitedScenery(double width, double height, double innerWidth, double innerHeight, Scenery delegate) {
        this.width = width;
        this.height = height;
        this.innerWidth = innerWidth;
        this.innerHeight = innerHeight;
        this.delegate = delegate;
    }

    @Override
    public IndependentClause asPerceivedBy(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
        Coordinates coord1 = CoordinateState.get(perceiver, frame);
        Coordinates coord2 = CoordinateState.get(associatedNoun, frame);
        if (coord1 == null || coord2 == null) {
            return null;
        }
        double dx = Math.abs(coord1.x - coord2.x);
        double dy = Math.abs(coord1.y - coord2.y);
        if (dx <= this.width && dy <= this.height && (dx > this.innerWidth || dy > this.innerHeight)) {
            return this.delegate.asPerceivedBy(perceiver, direction, associatedNoun, channel, frame);
        }
        return null;
    }

    @Override
    public double getPerceivedDistance(Noun noun1, Noun noun2, Frame frame) {
        return this.delegate.getPerceivedDistance(noun1, noun2, frame);
    }
}

