/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.notification;

import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import java.util.Objects;

public class Notification
implements StateChangeRequest {
    public final Noun player;
    public final NotificationKey key;
    public final String message;
    public final long interval;
    public final long duration;
    public final Event.Style style;
    public final boolean notifyOnMessageChange;
    public final boolean notifyPeriodically;

    public Notification(String message, Noun player, NotificationKey key, long interval, long duration, Event.Style style) {
        this.player = player;
        this.message = message;
        this.key = key;
        this.interval = interval;
        this.duration = duration;
        this.style = style;
        this.notifyOnMessageChange = true;
        this.notifyPeriodically = true;
    }

    private Notification(Builder builder) {
        this.player = Objects.requireNonNull(builder.player);
        this.message = builder.message;
        this.key = Objects.requireNonNull(builder.key);
        this.interval = builder.interval;
        this.duration = builder.duration;
        this.style = Objects.requireNonNull(builder.style);
        this.notifyOnMessageChange = builder.notifyOnMessageChange;
        this.notifyPeriodically = builder.notifyPeriodically;
    }

    public Notification(String message, Noun player, NotificationKey key, long interval, long duration) {
        this(message, player, key, interval, duration, Event.Style.DEFAULT);
    }

    public Notification(String message, Noun player, NotificationKey key) {
        this(message, player, key, 60L, 2L);
    }

    public static Builder builder(Noun player, NotificationKey key) {
        return new Builder(player, key);
    }

    public static final class Builder {
        public final Noun player;
        public final NotificationKey key;
        public String message;
        public long interval = 60L;
        public long duration = 2L;
        public Event.Style style = Event.Style.DEFAULT;
        public boolean notifyOnMessageChange = true;
        public boolean notifyPeriodically = true;

        private Builder(Noun player, NotificationKey key) {
            this.player = Objects.requireNonNull(player);
            this.key = Objects.requireNonNull(key);
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder notifyPeriodically(long interval) {
            this.interval = interval;
            this.notifyPeriodically = true;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setNotifyOnMessageChange(boolean notifyOnMessageChange) {
            this.notifyOnMessageChange = notifyOnMessageChange;
            return this;
        }

        public Builder setStyle(Event.Style style) {
            this.style = style;
            return this;
        }

        public Notification build() {
            return new Notification(this);
        }
    }
}

