/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.inventory;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.inventory.InventoryStateChangeRequest;

public class WieldRequest
implements InventoryStateChangeRequest {
    private final Perceiver who;
    private final Noun what;

    public WieldRequest(Perceiver who, Noun what) {
        this.who = who;
        this.what = what;
    }

    @Override
    public void apply(InventoryState.Builder builder, Simulation simulation) {
        builder.wield(this.who, this.what);
        NounPhrase perceptionOfItem = this.what.getDefaultPerception(simulation.getCurrentFrame());
        PlayerNotificationEvent.post((Noun)this.who, simulation, "You wield " + NounPhraseWithArticle.the(perceptionOfItem));
    }

    public static void request(Perceiver who, Noun what, Simulation simulation) {
        simulation.requestStateChange(InventoryState.class, new WieldRequest(who, what));
    }
}

