/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.inventory;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.states.encumbrance.EncumbranceState;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryAddItemsRequest;
import com.fabriziopolo.textcraft.states.inventory.InventoryRemoveItemsRequest;
import com.fabriziopolo.textcraft.states.inventory.InventoryRemoveWearableRequest;
import com.fabriziopolo.textcraft.states.inventory.InventoryStateChangeRequest;
import com.fabriziopolo.textcraft.states.inventory.InventoryWearItemRequest;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class InventoryState
implements State {
    private final Map<Noun, Inventory> inventoryMap = new HashMap<Noun, Inventory>();
    private final Map<Noun, Noun> wieldMap;
    private final Map<Noun, Map<WearableCategory, Noun>> wearableMap;

    public InventoryState(Builder builder) {
        builder.inventoryMap.keySet().forEach(noun -> {
            Inventory invForNoun = ((Inventory.Builder)builder.inventoryMap.get(noun)).build();
            this.inventoryMap.put((Noun)noun, invForNoun);
        });
        this.wieldMap = new HashMap<Noun, Noun>();
        this.wieldMap.putAll(builder.wieldMap);
        this.wearableMap = new HashMap<Noun, Map<WearableCategory, Noun>>();
        builder.wearableMap.forEach((noun, map) -> {
            HashMap newMap = new HashMap();
            newMap.putAll(map);
            this.wearableMap.put((Noun)noun, newMap);
        });
    }

    public static InventoryState get(Frame frame) {
        return (InventoryState)frame.states.get(InventoryState.class);
    }

    public Inventory get(Noun noun) {
        Inventory maybeInventory = this.inventoryMap.get(noun);
        if (maybeInventory == null) {
            return Inventory.createEmpty(noun);
        }
        return maybeInventory;
    }

    public Noun getWieldedItem(Noun noun) {
        return this.wieldMap.get(noun);
    }

    public boolean isWielding(Noun noun) {
        return this.wieldMap.containsKey(noun);
    }

    public static boolean isInInventory(Noun owner, Noun noun, Frame frame) {
        Inventory inventory = InventoryState.get(frame).get(owner);
        HashSet<Noun> inventoryItems = new HashSet<Noun>(inventory.getItems());
        PositionState positionState = PositionState.get(frame);
        for (Noun item : inventory.getItems()) {
            List<Noun> nonintegralDescendents = StructureState.getNonintegralDescendents(item, frame, positionState);
            if (nonintegralDescendents == null) continue;
            inventoryItems.addAll(nonintegralDescendents);
        }
        if (inventoryItems.isEmpty()) {
            return false;
        }
        Noun currNoun = noun;
        while (currNoun != null) {
            if (inventoryItems.contains(currNoun)) {
                return true;
            }
            currNoun = positionState.getParent(currNoun);
        }
        return false;
    }

    public static Inventory getContainingInventory(Noun noun, Frame frame) {
        for (Inventory inv : InventoryState.get((Frame)frame).inventoryMap.values()) {
            if (!inv.getItems().contains(noun)) continue;
            return inv;
        }
        return null;
    }

    public static boolean isInAnInventory(Noun noun, Frame frame) {
        return InventoryState.getContainingInventory(noun, frame) != null;
    }

    public static Map<WearableCategory, Noun> getWornItemsMap(Noun noun, Frame frame) {
        return InventoryState.get((Frame)frame).wearableMap.get(noun);
    }

    public static Collection<Noun> getWornItems(Noun noun, Frame frame) {
        Map<WearableCategory, Noun> map = InventoryState.getWornItemsMap(noun, frame);
        return map == null ? new ArrayList() : map.values();
    }

    public static Noun getLocation(Noun item, Frame frame) {
        Inventory inv = InventoryState.getContainingInventory(item, frame);
        if (inv == null) {
            return item;
        }
        return inv.getOwner();
    }

    @Override
    public State updateState(Simulation simulation) {
        Builder builder = InventoryState.builder(this);
        List<InventoryStateChangeRequest> reqs = this.getRequests(simulation);
        reqs.forEach(req -> req.apply(builder, simulation));
        return builder.build();
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(InventoryState.class);
        builder.addLine("items", this.inventoryMap.get(noun));
        builder.addLine("wielding", this.getWieldedItem(noun));
        builder.addLine("wearing", this.wearableMap.get(noun));
        Inventory containingInventory = InventoryState.getContainingInventory(noun, frame);
        if (containingInventory != null) {
            builder.addLine("inInventoryOf", containingInventory.getOwner());
        }
        if (this.inventoryMap.get(noun) != null) {
            builder.addLine("encumbrance", InventoryState.getEncumbrance(noun, frame));
        }
        return builder.toString();
    }

    public static double getEncumbrance(Noun owner, Frame frame) {
        EncumbranceState encumbranceState = EncumbranceState.get(frame);
        InventoryState inventoryState = InventoryState.get(frame);
        Collection<Noun> wornItems = InventoryState.getWornItems(owner, frame);
        return inventoryState.get(owner).getItems().stream().filter(item -> !wornItems.contains(item)).mapToDouble(item -> encumbranceState.get((Noun)item, null, frame)).sum();
    }

    public static void requestRemoveItem(Noun player, Noun item, Simulation simulation) {
        InventoryRemoveItemsRequest.post(player, item, simulation);
    }

    public static void requestAddItem(Noun player, Noun item, Simulation simulation) {
        simulation.requestStateChange(InventoryState.class, InventoryAddItemsRequest.create(player, item));
    }

    public static void requestAddItemWithoutNotifying(Noun player, Noun item, Simulation simulation) {
        simulation.requestStateChange(InventoryState.class, InventoryAddItemsRequest.createNoNotify(player, item));
    }

    public static void requestWearItem(Noun player, Noun item, WearableCategory category, Simulation simulation) {
        simulation.requestStateChange(InventoryState.class, new InventoryWearItemRequest(player, item, category));
    }

    public static void requestRemoveWearable(Noun player, Noun item, Simulation simulation) {
        simulation.requestStateChange(InventoryState.class, new InventoryRemoveWearableRequest(player, item));
    }

    private List<InventoryStateChangeRequest> getRequests(Simulation simulation) {
        List<StateChangeRequest> reqs = simulation.getStateChangeRequests(InventoryState.class);
        if (reqs == null) {
            return new ArrayList<InventoryStateChangeRequest>();
        }
        return reqs.stream().map(obj -> (InventoryStateChangeRequest)obj).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InventoryState inventoryState) {
        return new Builder(inventoryState);
    }

    private static Map<WearableCategory, Noun> getOrCreateWearableMap(Noun who, Map<Noun, Map<WearableCategory, Noun>> wearableMap) {
        Map<WearableCategory, Noun> map = wearableMap.get(who);
        if (map == null) {
            map = new HashMap<WearableCategory, Noun>();
            wearableMap.put(who, map);
        }
        return map;
    }

    public static List<Noun> getItemList(Noun noun, Frame frame) {
        Inventory inventory = InventoryState.get(frame).get(noun);
        if (inventory == null) {
            return new ArrayList<Noun>();
        }
        return new ArrayList<Noun>(inventory.getItems());
    }

    public static class Builder {
        private final Map<Noun, Inventory.Builder> inventoryMap = new HashMap<Noun, Inventory.Builder>();
        private final Map<Noun, Noun> wieldMap = new HashMap<Noun, Noun>();
        private final Map<Noun, Map<WearableCategory, Noun>> wearableMap = new HashMap<Noun, Map<WearableCategory, Noun>>();

        private Builder() {
        }

        private Builder(InventoryState inventoryState) {
            inventoryState.inventoryMap.entrySet().forEach(entry -> this.inventoryMap.put((Noun)entry.getKey(), Inventory.builder((Inventory)entry.getValue())));
            this.wieldMap.putAll(inventoryState.wieldMap);
            inventoryState.wearableMap.forEach((noun, map) -> {
                HashMap newMap = new HashMap();
                newMap.putAll(map);
                this.wearableMap.put((Noun)noun, newMap);
            });
        }

        public Builder give(Noun who, Noun what) {
            if (!this.inventoryMap.containsKey(who)) {
                this.inventoryMap.put(who, Inventory.builder(who));
            }
            this.inventoryMap.get(who).addItem(what);
            return this;
        }

        public Builder discard(Noun who, Noun what) {
            if (this.inventoryMap.containsKey(who)) {
                this.inventoryMap.get(who).removeItem(what);
            }
            if (this.wieldMap.get(who) == what) {
                this.unWield(who);
            }
            this.remove(who, what);
            return this;
        }

        public Builder wield(Noun who, Noun what) {
            this.wieldMap.put(who, what);
            return this;
        }

        public Builder unWield(Noun who) {
            this.wieldMap.remove(who);
            return this;
        }

        public Builder wear(Noun who, WearableCategory category, Noun what) {
            Map map = InventoryState.getOrCreateWearableMap(who, this.wearableMap);
            map.put(category, what);
            return this;
        }

        public Builder remove(Noun who, Noun what) {
            Map<WearableCategory, Noun> map = this.wearableMap.get(who);
            if (map == null) {
                return this;
            }
            if (!map.containsValue(what)) {
                return this;
            }
            WearableCategory category = null;
            for (WearableCategory cat : map.keySet()) {
                if (!map.get((Object)cat).equals(what)) continue;
                category = cat;
            }
            if (category != null) {
                map.remove((Object)category);
            }
            return this;
        }

        public InventoryState build() {
            return new InventoryState(this);
        }
    }
}

