/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio.oxygen;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.NotifyingNumberWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;

public class OxygenState
extends NotifyingNumberWithCauseState {
    private static final NotificationKey NOTIFICATION_KEY = new NotificationKey(OxygenState.class, "oxygen");
    private static final int NOTIFICATION_REPEAT_RATE = 5;
    private static final int NOTIFICATION_TIMEOUT = 1;
    private static final double SUFFOCATION_DAMAGE_RATE = -0.1;

    @Override
    protected NotificationKey getNotificationKey() {
        return NOTIFICATION_KEY;
    }

    @Override
    protected int getNotificationRepeatRate() {
        return 5;
    }

    @Override
    protected int getNotificationTimeout() {
        return 1;
    }

    @Override
    protected String getIncreaseDescription() {
        return "regain your breath";
    }

    @Override
    protected String getDecreaseDescription() {
        return "are running out of oxygen";
    }

    @Override
    protected Class getStateKey() {
        return OxygenState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        OxygenState newState = new OxygenState();
        this.setUpdatedState(simulation, newState);
        newState.setImmutable();
        OxygenState.applySuffocation(simulation, this);
        return newState;
    }

    public static OxygenState get(Frame frame) {
        return (OxygenState)frame.states.get(OxygenState.class);
    }

    @Override
    public NotifyingNumberWithCauseState.NumberWithCauses get(Noun noun) {
        return (NotifyingNumberWithCauseState.NumberWithCauses)super.get(noun);
    }

    public static void requestChange(Noun noun, double delta, IndependentClause cause, Simulation simulation) {
        OxygenState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, delta, cause);
    }

    public static void requestChangeWithoutCause(Noun noun, double delta, Simulation simulation) {
        OxygenState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, delta, null);
    }

    private static void applySuffocation(Simulation simulation, OxygenState oxygenState) {
        oxygenState.getValueMap().forEach((noun, vwc) -> {
            if (vwc.value <= 0.0) {
                IndependentClause cause = Nlg.literalClause("you are suffocating");
                HealthState.requestChange(noun, -0.1, cause, simulation);
            }
        });
    }
}

