/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio.awake;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.NotifyingNumberWithCauseState;
import com.fabriziopolo.textcraft.states.ValueWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeStateBuilder;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;
import com.fabriziopolo.textcraft.states.water.WaterState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;

public final class AwakeStateChangeManager {
    private AwakeStateChangeManager() {
    }

    public static void manageChange(Noun noun, AwakeState oldState, AwakeStateBuilder newState, Simulation simulation) {
        ValueWithCauseState.ValueWithCause<Boolean> result;
        Frame frame = simulation.getCurrentFrame();
        Boolean isAwake = oldState.isAwake(noun);
        Boolean willBeAwake = newState.isAwake(noun);
        if (isAwake == null) {
            isAwake = willBeAwake;
            if (willBeAwake == null) {
                return;
            }
        }
        if (!willBeAwake.booleanValue()) {
            ValueWithCauseState.ValueWithCause<Boolean> sleepingStateLethal = AwakeStateChangeManager.isSleepingStateLethal(noun, frame);
            if (((Boolean)sleepingStateLethal.value).booleanValue()) {
                HealthState.get(frame);
                HealthState.requestChange(noun, -1.0, sleepingStateLethal.causeDescription, simulation);
            }
        }
        if ((result = AwakeStateChangeManager.getChange(noun, isAwake, willBeAwake, frame)) == null) {
            return;
        }
        newState.set(noun, result);
    }

    public static ValueWithCauseState.ValueWithCause<Boolean> getChange(Noun noun, Boolean isAwake, Boolean willBeAwake, Frame frame) {
        if (isAwake.booleanValue()) {
            if (AwakeStateChangeManager.shouldBlackOut(noun, frame)) {
                return AwakeStateChangeManager.getChangeBlackOut();
            }
        } else if (AwakeStateChangeManager.shouldRemainBlackedOut(noun, frame)) {
            return AwakeStateChangeManager.getChangeRemainBlackedOut();
        }
        ValueWithCauseState.ValueWithCause<Boolean> result = SunState.isNight(frame) ? AwakeStateChangeManager.getChangeAtNight(noun, isAwake, willBeAwake, frame) : AwakeStateChangeManager.getChangeDuringDay(noun, isAwake, willBeAwake, frame);
        return result;
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getChangeDuringDay(Noun noun, Boolean isAwake, Boolean willBeAwake, Frame frame) {
        if (isAwake.booleanValue()) {
            if (willBeAwake.booleanValue()) {
                return null;
            }
            return AwakeStateChangeManager.getChangeGoToSleepDuringDay(noun, frame);
        }
        if (willBeAwake.booleanValue()) {
            return null;
        }
        return AwakeStateChangeManager.getChangeWakeUpDuringDay(noun, frame);
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getChangeAtNight(Noun noun, Boolean isAwake, Boolean willBeAwake, Frame frame) {
        if (isAwake.booleanValue()) {
            if (willBeAwake.booleanValue()) {
                return null;
            }
            return null;
        }
        if (willBeAwake.booleanValue()) {
            return null;
        }
        return AwakeStateChangeManager.getChangeWakeUpAtNight(noun, frame);
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getChangeBlackOut() {
        return ValueWithCauseState.ValueWithCause.create(false, "you black out from exhaustion");
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getChangeRemainBlackedOut() {
        return AwakeStateChangeManager.getChangeBlackOut();
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getChangeGoToSleepDuringDay(Noun noun, Frame frame) {
        EnergyState energyState = EnergyState.get(frame);
        NotifyingNumberWithCauseState.NumberWithCauses vwc = energyState.get(noun);
        if (vwc == null) {
            return ValueWithCauseState.ValueWithCause.create(true);
        }
        Double maxEnergy = energyState.getMaxEnergy(noun, frame);
        Double energy = vwc.value;
        if (energy > maxEnergy * 0.7) {
            return ValueWithCauseState.ValueWithCause.create(true, "you are not tired enough");
        }
        return ValueWithCauseState.ValueWithCause.create(false);
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getChangeWakeUpDuringDay(Noun noun, Frame frame) {
        ValueWithCauseState.ValueWithCause<Boolean> changeWakeUpAtNight = AwakeStateChangeManager.getUniversalChangeWakeUp(noun, frame);
        if (changeWakeUpAtNight != null) {
            return changeWakeUpAtNight;
        }
        EnergyState energyState = EnergyState.get(frame);
        NotifyingNumberWithCauseState.NumberWithCauses vwc = energyState.get(noun);
        if (vwc == null) {
            return ValueWithCauseState.ValueWithCause.create(false);
        }
        Double maxEnergy = energyState.getMaxEnergy(noun, frame);
        Double energy = vwc.value;
        if (energy > maxEnergy * 0.8) {
            return ValueWithCauseState.ValueWithCause.create(true);
        }
        return ValueWithCauseState.ValueWithCause.create(false);
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getChangeWakeUpAtNight(Noun noun, Frame frame) {
        return AwakeStateChangeManager.getUniversalChangeWakeUp(noun, frame);
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> getUniversalChangeWakeUp(Noun noun, Frame frame) {
        ValueWithCauseState.ValueWithCause<Boolean> sleepingStateLethal = AwakeStateChangeManager.isSleepingStateLethal(noun, frame);
        if (((Boolean)sleepingStateLethal.value).booleanValue()) {
            return sleepingStateLethal;
        }
        if (RainEffectState.isRainingOn(noun, frame)) {
            return ValueWithCauseState.ValueWithCause.create(true, "it is raining");
        }
        if (TemperatureState.getTemperatureAt(noun, frame).getFlexibleValue() > 3.0) {
            return ValueWithCauseState.ValueWithCause.create(true, "you are too hot");
        }
        return null;
    }

    private static ValueWithCauseState.ValueWithCause<Boolean> isSleepingStateLethal(Noun noun, Frame frame) {
        if (WaterState.isInWater(noun, frame)) {
            return ValueWithCauseState.ValueWithCause.create(true, "you drown because you black out while you are in water");
        }
        return ValueWithCauseState.ValueWithCause.create(false);
    }

    private static boolean shouldBlackOut(Noun noun, Frame frame) {
        NotifyingNumberWithCauseState.NumberWithCauses energyWithCause = EnergyState.get(frame).get(noun);
        if (energyWithCause == null) {
            return false;
        }
        return energyWithCause.value <= 0.0;
    }

    private static boolean shouldRemainBlackedOut(Noun noun, Frame frame) {
        NotifyingNumberWithCauseState.NumberWithCauses energyWithCause = EnergyState.get(frame).get(noun);
        if (energyWithCause == null) {
            return false;
        }
        return energyWithCause.value <= 0.05;
    }
}

