/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio.awake;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.events.position.PlayerExaminesSurroundingsEvent;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.ValueWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeStateBuilder;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeStateChangeManager;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.text.Text;
import java.io.Serializable;
import java.util.HashMap;

public class AwakeState
extends ValueWithCauseState<Boolean> {
    private static final double ENERGY_REGENERATION_WHILE_SLEEPING_PER_GAME_HOUR = 0.1;

    public static AwakeState get(Frame frame) {
        return (AwakeState)frame.states.get(AwakeState.class);
    }

    @Override
    protected Boolean combinePureValues(Noun noun, Boolean t1, Boolean t2, IndependentClause cause1, IndependentClause cause2, Simulation simulation) {
        return t2;
    }

    @Override
    protected Class getStateKey() {
        return AwakeState.class;
    }

    private AwakeState getUpdatedAwakeState(Simulation simulation) {
        AwakeStateBuilder newState = new AwakeStateBuilder();
        this.setUpdatedState(simulation, newState);
        new HashMap(newState.getValueMap()).forEach((noun, vwc) -> AwakeStateChangeManager.manageChange(noun, this, newState, simulation));
        return newState.build();
    }

    @Override
    public State updateState(Simulation simulation) {
        AwakeState newState = this.getUpdatedAwakeState(simulation);
        newState.getValueMap().forEach((noun, valueWithCause) -> {
            Serializable oldValueWithCause = this.get((Noun)noun);
            if (AwakeState.didChangeState((ValueWithCauseState.ValueWithCause<Boolean>)oldValueWithCause, valueWithCause)) {
                this.notify((Noun)noun, (ValueWithCauseState.ValueWithCause<Boolean>)valueWithCause, simulation);
            }
        });
        this.recuperate(simulation);
        return newState;
    }

    private void notify(Noun noun, ValueWithCauseState.ValueWithCause<Boolean> valueWithCause, Simulation simulation) {
        String notificationMessage = this.getNotificationMessage(noun, valueWithCause, simulation);
        if (notificationMessage != null) {
            PlayerNotificationEvent.postAlwaysPerceivable(noun, notificationMessage, simulation);
        }
        if (((Boolean)valueWithCause.value).booleanValue()) {
            PlayerExaminesSurroundingsEvent.post(noun, simulation);
        }
    }

    private static boolean didWakeUp(ValueWithCauseState.ValueWithCause<Boolean> oldVwc, ValueWithCauseState.ValueWithCause<Boolean> newVwc) {
        if (newVwc == null || !((Boolean)newVwc.value).booleanValue()) {
            return false;
        }
        return oldVwc == null || (Boolean)oldVwc.value == false;
    }

    private static boolean didChangeState(ValueWithCauseState.ValueWithCause<Boolean> oldVwc, ValueWithCauseState.ValueWithCause<Boolean> newVwc) {
        if (newVwc == null) {
            return oldVwc != null;
        }
        if (oldVwc == null) {
            return true;
        }
        return !((Boolean)newVwc.value).equals(oldVwc.value);
    }

    public Boolean isAwake(Noun noun) {
        Serializable valueWithCause = this.get(noun);
        if (valueWithCause == null) {
            return null;
        }
        return (Boolean)((ValueWithCauseState.ValueWithCause)valueWithCause).value;
    }

    @Override
    public ValueWithCauseState.ValueWithCause<Boolean> get(Noun noun) {
        return (ValueWithCauseState.ValueWithCause)super.get(noun);
    }

    private void recuperate(Simulation simulation) {
        this.getValueMap().forEach((noun, valueWithCause) -> {
            if (!((Boolean)valueWithCause.value).booleanValue()) {
                this.recuperate((Noun)noun, simulation);
            }
        });
    }

    private void recuperate(Noun noun, Simulation simulation) {
        Double energy = EnergyState.get(simulation.getCurrentFrame()).getValue(noun);
        if (energy != null) {
            double restoredEnergy = 2.777777777777778E-5 * simulation.getUpdateParameters().getGameTimeDtSeconds();
            EnergyState.requestChange(noun, restoredEnergy, Nlg.literalClause("you slept"), simulation);
        }
    }

    private String getNotificationMessage(Noun noun, ValueWithCauseState.ValueWithCause<Boolean> valueWithCause, Simulation simulation) {
        if (((Boolean)valueWithCause.value).booleanValue()) {
            Sentences firstSentence = valueWithCause.causeDescription == null || valueWithCause.causeDescription.toString().isEmpty() ? Nlg.literalSentences("You wake up.") : Nlg.literalSentences("You wake up because " + valueWithCause.causeDescription + ".");
            Sentences secondSentence = DescriptionState.getPerceptionOfTimeOfDay(noun, simulation.getCurrentFrame());
            return "..." + Text.getLineSeparator() + new MultipleSentences(firstSentence, secondSentence).toString();
        }
        String msg = valueWithCause.causeDescription == null || valueWithCause.causeDescription.toString().isEmpty() ? "You fall asleep." : "You fall asleep because " + valueWithCause.causeDescription + ".";
        return msg + Text.getLineSeparator() + "...";
    }

    public static AwakeStateBuilder builder() {
        return new AwakeStateBuilder();
    }

    public static void requestAwake(Noun noun, Simulation simulation) {
        AwakeState.requestAwake(noun, null, simulation);
    }

    public static void requestAwake(Noun noun, IndependentClause cause, Simulation simulation) {
        AwakeState.requestChange(noun, cause, true, simulation);
    }

    public static void requestWakeUpIfHasAwakeState(Noun noun, IndependentClause cause, Simulation simulation) {
        Serializable isAwakeWithCause = AwakeState.get(simulation.getCurrentFrame()).get(noun);
        if (isAwakeWithCause != null && !((Boolean)((ValueWithCauseState.ValueWithCause)isAwakeWithCause).value).booleanValue()) {
            AwakeState.requestAwake(noun, cause, simulation);
        }
    }

    public static void requestSleep(Noun noun, Simulation simulation) {
        AwakeState.requestChange(noun, null, false, simulation);
    }

    public static void requestChange(Noun noun, IndependentClause clause, boolean isAwake, Simulation simulation) {
        simulation.requestStateChange(AwakeState.class, new ValueState.ChangeRequest<ValueWithCauseState.ValueWithCause<Boolean>>(noun, new ValueWithCauseState.ValueWithCause<Boolean>(isAwake, clause)));
    }
}

