/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states;

import com.fabriziopolo.textcraft.nlg.Conjunctions;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.IndependentClausesWithConjunction;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.notification.Notification;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.notification.NotificationState;
import java.io.Serializable;

public abstract class NotifyingNumberWithCauseState
extends ValueState<NumberWithCauses> {
    protected double combinePureValues(Noun noun, double t1, double t2, Simulation simulation) {
        return t1 + t2;
    }

    @Override
    protected void setUpdatedState(Simulation simulation, ValueState<NumberWithCauses> newStateBuilder) {
        this.getValueMap().forEach((noun, valueWithCause) -> newStateBuilder.set((Noun)noun, new NumberWithCauses(valueWithCause.value, null, false)));
        newStateBuilder.applyUpdates(simulation);
        newStateBuilder.getValueMap().replaceAll((noun, valueWithCause) -> valueWithCause.withNewValue(Math.max(this.getMinValue(), Math.min(this.getMaxValue(), valueWithCause.value))));
        this.notifyNounsOfChangeCauses(simulation, newStateBuilder);
    }

    protected abstract String getIncreaseDescription();

    protected abstract String getDecreaseDescription();

    protected double getMinValue() {
        return 0.0;
    }

    protected double getMaxValue() {
        return 1.0;
    }

    protected Event.Style getNotificationStyle(double value, double change) {
        return Event.Style.DEFAULT;
    }

    private String getChangeDescription(double value) {
        if (value < 0.0) {
            return this.getDecreaseDescription();
        }
        return this.getIncreaseDescription();
    }

    protected String getNotificationMessage(Noun noun, NumberWithCauses valueWithCause, double change) {
        IndependentClause cause;
        double value = valueWithCause.value;
        if (change == 0.0) {
            change = value == this.getMaxValue() ? 1.0 : -1.0;
        }
        if ((cause = valueWithCause.getCause(change)) != null) {
            return "You " + this.getChangeDescription(change) + " because " + cause + ".";
        }
        return null;
    }

    protected abstract NotificationKey getNotificationKey();

    protected abstract int getNotificationRepeatRate();

    protected abstract int getNotificationTimeout();

    private void notifyNounsOfChangeCauses(Simulation simulation, ValueState<NumberWithCauses> newState) {
        newState.getValueMap().forEach((noun, valueWithCause) -> {
            double change;
            String notificationMessage;
            Double value;
            Double d = value = this.get((Noun)noun) == null ? null : Double.valueOf(((NumberWithCauses)this.get((Noun)noun)).value);
            if (value != null && (notificationMessage = this.getNotificationMessage((Noun)noun, (NumberWithCauses)valueWithCause, change = valueWithCause.value - value)) != null) {
                NotificationState.post(simulation, Notification.builder(noun, this.getNotificationKey()).setMessage(notificationMessage).setDuration(this.getNotificationTimeout()).notifyPeriodically(this.getNotificationRepeatRate()).setNotifyOnMessageChange(valueWithCause.notifyOfChanges).setStyle(this.getNotificationStyle(valueWithCause.value, change)).build());
            }
        });
    }

    @Override
    protected abstract Class getStateKey();

    public Double getValue(Noun noun) {
        NumberWithCauses valueWithCause = (NumberWithCauses)this.get(noun);
        if (valueWithCause == null) {
            return null;
        }
        return valueWithCause.value;
    }

    @Override
    public NumberWithCauses combineValues(Noun noun, NumberWithCauses t1, NumberWithCauses t2, Simulation simulation) {
        if (t2 == null) {
            return t1;
        }
        if (t1 == null) {
            return t2;
        }
        double combinedPureValues = this.combinePureValues(noun, t1.value, t2.value, simulation);
        IndependentClause newNegativeCauseDescription = IndependentClausesWithConjunction.combine(t1.negativeCause, Conjunctions.and, t2.negativeCause);
        IndependentClause newPositiveCauseDescription = IndependentClausesWithConjunction.combine(t1.positiveCause, Conjunctions.and, t2.positiveCause);
        boolean notifyOfChanges = t1.notifyOfChanges || t2.notifyOfChanges;
        return new NumberWithCauses(combinedPureValues, newNegativeCauseDescription, newPositiveCauseDescription, notifyOfChanges);
    }

    public void requestChange(Simulation simulation, Noun noun, double value, IndependentClause cause) {
        this.requestChange(simulation, noun, new NumberWithCauses(value, cause));
    }

    public void requestChange(Simulation simulation, Noun noun, double value, IndependentClause cause, boolean notifyOfChange) {
        this.requestChange(simulation, noun, new NumberWithCauses(value, cause, notifyOfChange));
    }

    public void requestChangeWithoutCause(Simulation simulation, Noun noun, double value) {
        this.requestChange(simulation, noun, new NumberWithCauses(value, null));
    }

    public static final class NumberWithCauses
    implements Serializable {
        public final double value;
        public final IndependentClause positiveCause;
        public final IndependentClause negativeCause;
        public final boolean notifyOfChanges;

        public NumberWithCauses(double value, IndependentClause causeDescription) {
            this(value, causeDescription, true);
        }

        public NumberWithCauses(double value, IndependentClause causeDescription, boolean notifyOfChanges) {
            this.value = value;
            this.positiveCause = value < 0.0 ? null : causeDescription;
            this.negativeCause = value < 0.0 ? causeDescription : null;
            this.notifyOfChanges = notifyOfChanges;
        }

        public NumberWithCauses(double value, IndependentClause negativeCause, IndependentClause positiveCause) {
            this(value, negativeCause, positiveCause, true);
        }

        public NumberWithCauses(double value, IndependentClause negativeCause, IndependentClause positiveCause, boolean notifyOfChanges) {
            this.value = value;
            this.negativeCause = negativeCause;
            this.positiveCause = positiveCause;
            this.notifyOfChanges = notifyOfChanges;
        }

        public static NumberWithCauses create(double value, String literalDescriptionClause) {
            return new NumberWithCauses(value, Nlg.literalClause(literalDescriptionClause));
        }

        public static NumberWithCauses create(double value) {
            return new NumberWithCauses(value, null);
        }

        public NumberWithCauses withNewValue(double value) {
            return new NumberWithCauses(value, this.negativeCause, this.positiveCause, this.notifyOfChanges);
        }

        public IndependentClause getCause() {
            return this.value < 0.0 ? this.negativeCause : this.positiveCause;
        }

        public IndependentClause getCause(double sign) {
            if (sign < 0.0) {
                return this.negativeCause;
            }
            return this.positiveCause;
        }

        public IndependentClause getNegativeCause() {
            return this.getCause(-1.0);
        }

        public String toString() {
            String str = " " + this.value;
            if (this.negativeCause != null) {
                str = str + " because- " + this.negativeCause;
            }
            if (this.positiveCause != null) {
                str = str + " because+ " + this.positiveCause;
            }
            return str;
        }
    }
}

