/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.simulation;

import java.io.Serializable;
import java.time.Duration;

public class UpdateParameters
implements Serializable {
    public static final double SECONDS_PER_DAY = 86400.0;
    public static final double SECONDS_PER_HOUR = 3600.0;
    private final double dt;
    private final double timeScale;

    public UpdateParameters(double dt, double timeScale) {
        this.dt = dt;
        this.timeScale = timeScale;
    }

    public double getPlayTimeDtSeconds() {
        return this.dt;
    }

    public double getGameTimeDtSeconds() {
        return this.dt * this.timeScale;
    }

    public Duration getGameTimeDtDuration() {
        return Duration.ofMillis((long)(this.getGameTimeDtSeconds() * 1000.0));
    }

    public double getTimeScale() {
        return this.timeScale;
    }

    public int getFramesPerDay() {
        return (int)(86400.0 / this.getGameTimeDtSeconds());
    }

    public double getDeltaForRatePerDay(double rate) {
        return rate / (double)this.getFramesPerDay();
    }
}

