/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.player;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilter;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilterState;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import java.util.Map;
import java.util.Objects;

public class WornItemTemperatureFilter
implements TemperatureFilter {
    private final Noun player;

    public WornItemTemperatureFilter(Noun player) {
        this.player = Objects.requireNonNull(player);
    }

    @Override
    public FlexibleHeatUnit applyFilter(FlexibleHeatUnit heat, Frame frame) {
        Map<WearableCategory, Noun> wornItemsMap = InventoryState.getWornItemsMap(this.player, frame);
        if (wornItemsMap == null) {
            return heat;
        }
        TemperatureFilterState temperatureFilterState = TemperatureFilterState.get(frame);
        for (Noun wornItem : wornItemsMap.values()) {
            TemperatureFilter filter = temperatureFilterState.getFilter(wornItem);
            if (filter == null) continue;
            heat = filter.applyFilter(heat, frame);
        }
        return heat;
    }
}

