/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.player;

import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.states.sun.SunEffect;

public class PlayerSunEffect
implements SunEffect {
    private final double perGameDayDehydrationRate;
    private double lastIntensity = 0.0;

    private PlayerSunEffect(double dehydrationRate) {
        this.perGameDayDehydrationRate = dehydrationRate;
    }

    public static PlayerSunEffect fromPerGameDayRate(double rate) {
        return new PlayerSunEffect(rate);
    }

    @Override
    public void onSun(Simulation simulation, Noun target, double intensity) {
        HydrationState hydrationState = HydrationState.get(simulation.getCurrentFrame());
        double delta = this.computeDehydrationFromIntensity(intensity, target, simulation);
        HydrationState.requestChangeWithoutCause(target, delta, simulation);
    }

    private double computeDehydrationFromIntensity(double intensity, Noun target, Simulation simulation) {
        UpdateParameters params = simulation.getUpdateParameters();
        double baseAmount = this.perGameDayDehydrationRate * params.getGameTimeDtSeconds() / 86400.0;
        intensity = (intensity - 0.2) / 0.8;
        this.lastIntensity = intensity = Math.max(0.0, Math.min(1.0, intensity));
        return baseAmount * intensity;
    }

    public String toString() {
        return CharacterBioEffect.builder().addHydration(this.lastIntensity).build().toString();
    }
}

