/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.player;

import com.fabriziopolo.textcraft.events.inventory.PlayerExaminesInventoryEvent;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.light.LightState;
import com.fabriziopolo.textcraft.states.light.PerceptionTracePathAlgorithm;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.scenery.Scenery;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Player
implements Perceiver {
    public static final double BLIND_LIGHT_THRESHOLD = 0.0;
    public static final double DARK_LIGHT_THRESHOLD = 0.2;
    public static final double MAX_WALKING_WATER_DEPTH = 0.5;
    public static final double SWIMMING_WATER_DEPTH = 0.75;
    public static final double MAX_SLEEPING_TEMPERATURE = 3.0;

    @Override
    public Sentences getPerceptionOf(Event event, Frame frame) {
        if (event == null) {
            return null;
        }
        if (this.isAsleep(frame) && !event.isAlwaysPerceivable()) {
            return null;
        }
        return event.asPerceivedBy(this, frame, PerceptionChannel.DEFAULT);
    }

    @Override
    public NounPhrase getPerceptionOf(Noun noun, Frame frame) {
        if (InventoryState.isInInventory(this, noun, frame)) {
            return noun.getDefaultPerception(frame);
        }
        if (noun == null || this.isAsleep(frame)) {
            return null;
        }
        PerceptionTracePathAlgorithm algorithm = new PerceptionTracePathAlgorithm();
        Noun perceivedNoun = algorithm.tracePerceptionBetween(this, noun, frame);
        return perceivedNoun.asPerceivedBy(this, algorithm.getFinalEntranceSpacialRelationship(), frame, this.chooseChannelByLightIntensity(noun, frame));
    }

    @Override
    public Sentences getVerbosePerceptionOf(Noun noun, Frame frame) {
        if (noun == null || this.isAsleep(frame)) {
            return null;
        }
        PerceptionTracePathAlgorithm algorithm = new PerceptionTracePathAlgorithm();
        Noun perceivedNoun = algorithm.tracePerceptionBetween(this, noun, frame);
        return perceivedNoun.asVerboselyPerceivedBy(this, algorithm.getFinalEntranceSpacialRelationship(), frame, this.chooseChannelByLightIntensity(noun, frame));
    }

    @Override
    public IndependentClause getPerceptionOf(Scenery scenery, Noun direction, Noun associatedNoun, Frame frame) {
        if (scenery == null || this.isAsleep(frame)) {
            return null;
        }
        return scenery.asPerceivedBy(this, direction, associatedNoun, this.chooseChannelForScenery(this, frame), frame);
    }

    @Override
    public List<Noun> getPerceivableNouns(Frame frame) {
        ArrayList<Noun> allNouns = new ArrayList<Noun>();
        PositionState positions = PositionState.get(frame);
        Noun room = StructureState.getSurroundParentOrRoot(this, frame);
        allNouns.add(room);
        List nounsInRoom = DescriptionState.get(frame).getExternallyPerceivableNounsDescendingFrom(room, frame).stream().filter(noun -> null != this.getPerceptionOf((Noun)noun, frame)).collect(Collectors.toList());
        allNouns.addAll(nounsInRoom);
        allNouns.forEach(noun -> {
            if (noun == null) {
                throw new RuntimeException();
            }
        });
        Inventory inventory = InventoryState.get(frame).get(this);
        List<Noun> items = inventory.getItems();
        allNouns.addAll(items);
        items.forEach(noun -> allNouns.addAll(positions.getDesendentsOf((Noun)noun)));
        allNouns.forEach(noun -> {
            if (noun == null) {
                throw new RuntimeException();
            }
        });
        return allNouns;
    }

    @Override
    public NounPhrase asPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        return Nlg.autoNounPhrase("player", "players", "self", "selves", "myself", "ourselves", "me", "us");
    }

    @Override
    public Sentences asVerboselyPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        if (!(perceiver instanceof Perceiver)) {
            return null;
        }
        return new PlayerExaminesInventoryEvent(this).asPerceivedBy((Perceiver)perceiver, frame, channel);
    }

    private PerceptionChannel chooseChannelByLightIntensity(Noun noun, Frame frame) {
        if (frame == null) {
            return PerceptionChannel.DEFAULT;
        }
        Inventory inventory = InventoryState.get(frame).get(this);
        if (inventory != null && inventory.getItems().contains(noun)) {
            return PerceptionChannel.DEFAULT;
        }
        double intensity = LightState.getBrightnessAt(noun, frame);
        return this.getPerceptionChannelFromLightIntensity(intensity);
    }

    private PerceptionChannel chooseChannelForScenery(Noun noun, Frame frame) {
        if (frame == null) {
            return PerceptionChannel.DEFAULT;
        }
        double intensity = SunState.get(frame).getIntensityAt(noun, frame);
        return this.getPerceptionChannelFromLightIntensity(intensity);
    }

    private PerceptionChannel getPerceptionChannelFromLightIntensity(double intensity) {
        if (intensity <= 0.0) {
            return PerceptionChannel.BLIND;
        }
        if (intensity < 0.2) {
            return PerceptionChannel.DARK;
        }
        return PerceptionChannel.DEFAULT;
    }

    private boolean isAsleep(Frame frame) {
        Boolean isAsleep = this.isAsleep(AwakeState.get(frame).isAwake(this));
        AwakeState prevAwakeState = (AwakeState)frame.prevStates.get(AwakeState.class);
        Boolean wasAsleep = prevAwakeState == null ? false : this.isAsleep(prevAwakeState.isAwake(this));
        return isAsleep != false && wasAsleep != false;
    }

    private boolean isAsleep(Boolean isAwake) {
        if (isAwake == null) {
            return true;
        }
        return isAwake == false;
    }

    public String toString() {
        return "<PLAYER>";
    }
}

