/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.objects;

import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import java.util.HashMap;
import java.util.Map;

public final class MultiSidedNoun
implements Noun {
    private final Map<SpacialRelationship, Noun> delegateMap = new HashMap<SpacialRelationship, Noun>();

    private MultiSidedNoun(Builder builder) {
        this.delegateMap.putAll(builder.delegateMap);
    }

    @Override
    public NounPhrase asPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        return this.getDelegate(spacialRelationship).asPerceivedBy(perceiver, spacialRelationship, frame, channel);
    }

    @Override
    public Sentences asVerboselyPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        return this.getDelegate(spacialRelationship).asVerboselyPerceivedBy(perceiver, spacialRelationship, frame, channel);
    }

    private Noun getDelegate(SpacialRelationship spacialRelationship) {
        return this.delegateMap.getOrDefault(spacialRelationship, this.delegateMap.get(null));
    }

    public static Builder builder(Noun defaultDelegate) {
        return new Builder(defaultDelegate);
    }

    public static final class Builder {
        private Map<SpacialRelationship, Noun> delegateMap = new HashMap<SpacialRelationship, Noun>();

        private Builder(Noun defaultDelegate) {
            this.delegateMap.put(null, defaultDelegate);
        }

        public Builder asViewedFacing(SpacialRelationship spacialRelationship, Noun noun) {
            this.delegateMap.put(spacialRelationship, noun);
            return this;
        }

        public MultiSidedNoun build() {
            return new MultiSidedNoun(this);
        }
    }
}

