/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Person;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.PrepositionalPhrase;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.Objects;

public final class NounPhraseWithPrepositionalPhrase
implements NounPhrase {
    private final NounPhrase baseNounPhrase;
    private final Preposition preposition;
    private final NounPhrase objectOfPreposition;
    private final boolean matchAsObjectOfPreposition;
    private final PrepositionalPhrase prepositionalPhrase;

    private NounPhraseWithPrepositionalPhrase(NounPhrase baseNounPhrase, Preposition preposition, NounPhrase objectOfPreposition, boolean matchAsObjectOfPreposition) {
        this.baseNounPhrase = Objects.requireNonNull(baseNounPhrase);
        this.preposition = Objects.requireNonNull(preposition);
        this.objectOfPreposition = Objects.requireNonNull(objectOfPreposition);
        this.matchAsObjectOfPreposition = matchAsObjectOfPreposition;
        this.prepositionalPhrase = new PrepositionalPhrase(preposition, objectOfPreposition);
    }

    @Override
    public Number getNumber() {
        return this.baseNounPhrase.getNumber();
    }

    @Override
    public Person getPerson() {
        return this.baseNounPhrase.getPerson();
    }

    @Override
    public boolean isCountNoun() {
        return this.baseNounPhrase.isCountNoun();
    }

    @Override
    public NounPhrase as(Number number) {
        return new NounPhraseWithPrepositionalPhrase(this.baseNounPhrase.as(number), this.preposition, this.objectOfPreposition, this.matchAsObjectOfPreposition);
    }

    @Override
    public TextMatcher.Result matches(String[] words, int startIndex, Frame frame) {
        TextMatcher.Result baseMatch = this.baseNounPhrase.matches(words, startIndex, frame);
        if (baseMatch.isMatch) {
            int idx = startIndex + baseMatch.numWordsMatched;
            TextMatcher.Result prepositionalPhraseMatch = this.prepositionalPhrase.matches(words, idx, frame);
            if (!prepositionalPhraseMatch.isMatch) {
                return baseMatch;
            }
            return TextMatcher.Result.createMatch(startIndex, baseMatch.numWordsMatched + prepositionalPhraseMatch.numWordsMatched);
        }
        if (this.matchAsObjectOfPreposition) {
            TextMatcher.Result objectMatch = this.objectOfPreposition.matches(words, startIndex, frame);
            if (objectMatch.isMatch) {
                return objectMatch;
            }
        }
        return TextMatcher.Result.createFailed();
    }

    public String toString() {
        return this.baseNounPhrase + " " + this.prepositionalPhrase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private NounPhrase baseNounPhrase;
        private Preposition preposition;
        private NounPhrase objectOfPreposition;
        private boolean matchAsObjectOfPreposition = false;

        public Builder setBaseNounPhrase(NounPhrase baseNounPhrase) {
            this.baseNounPhrase = baseNounPhrase;
            return this;
        }

        public Builder setPreposition(Preposition preposition) {
            this.preposition = preposition;
            return this;
        }

        public Builder setObjectOfPreposition(NounPhrase objectOfPreposition) {
            this.objectOfPreposition = objectOfPreposition;
            return this;
        }

        public Builder setMatchAsObjectOfPreposition(boolean matchAsObjectOfPreposition) {
            this.matchAsObjectOfPreposition = matchAsObjectOfPreposition;
            return this;
        }

        public NounPhraseWithPrepositionalPhrase build() {
            return new NounPhraseWithPrepositionalPhrase(this.baseNounPhrase, this.preposition, this.objectOfPreposition, this.matchAsObjectOfPreposition);
        }
    }
}

