/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.AdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Person;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.Objects;

public class NounPhraseWithAdjective
implements NounPhrase {
    private final NounPhrase nounPhrase;
    private final AdjectivePhrase adjectivePhrase;

    public NounPhraseWithAdjective(AdjectivePhrase adjectivePhrase, NounPhrase nounPhrase) {
        this.adjectivePhrase = Objects.requireNonNull(adjectivePhrase);
        this.nounPhrase = Objects.requireNonNull(nounPhrase);
    }

    @Override
    public Number getNumber() {
        return this.nounPhrase.getNumber();
    }

    @Override
    public Person getPerson() {
        return this.nounPhrase.getPerson();
    }

    @Override
    public boolean isCountNoun() {
        return this.nounPhrase.isCountNoun();
    }

    @Override
    public NounPhrase as(Number number) {
        return new NounPhraseWithAdjective(this.adjectivePhrase, this.nounPhrase.as(number));
    }

    @Override
    public TextMatcher.Result matches(String[] words, int startIndex, Frame frame) {
        if (words.length <= startIndex) {
            return TextMatcher.Result.createFailed();
        }
        if (words[startIndex].toLowerCase().equals(this.adjectivePhrase.toString().toLowerCase())) {
            return this.nounPhrase.matches(words, startIndex + 1, frame);
        }
        return this.nounPhrase.matches(words, startIndex, frame);
    }

    public String toString() {
        return this.adjectivePhrase.toString() + " " + this.nounPhrase.toString();
    }
}

