/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.Conjunction;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class IndependentClausesWithConjunction
implements IndependentClause {
    private final List<IndependentClause> clauses;
    private final Conjunction conjunction;

    public IndependentClausesWithConjunction(List<IndependentClause> clauses, Conjunction conjunction) {
        this.clauses = clauses;
        this.conjunction = conjunction;
    }

    public static IndependentClausesWithConjunction create(IndependentClause clause1, Conjunction conjunction, IndependentClause clause2) {
        ArrayList<IndependentClause> clauses = new ArrayList<IndependentClause>();
        clauses.add(clause1);
        clauses.add(clause2);
        return new IndependentClausesWithConjunction(clauses, conjunction);
    }

    public String toString() {
        if (this.clauses.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.clauses.get(0));
        for (int i = 1; i < this.clauses.size(); ++i) {
            builder.append(" ");
            builder.append(this.conjunction);
            builder.append(" ");
            builder.append(this.clauses.get(i));
        }
        return builder.toString();
    }

    public static IndependentClause combine(IndependentClause clause1, Conjunction conjunction, IndependentClause clause2) {
        IndependentClause newCauseDescription;
        if (clause1 == null) {
            newCauseDescription = clause2 == null ? null : clause2;
        } else if (clause2 == null) {
            newCauseDescription = clause1;
        } else {
            ArrayList<IndependentClause> allCauses = new ArrayList<IndependentClause>();
            allCauses.add(clause1);
            allCauses.add(clause2);
            newCauseDescription = new IndependentClausesWithConjunction(allCauses, conjunction);
        }
        return newCauseDescription;
    }

    public static IndependentClause combineAll(List<IndependentClause> clauses, Conjunction conjunction) {
        Optional reduce = clauses.stream().reduce((clause1, clause2) -> IndependentClausesWithConjunction.combine(clause1, conjunction, clause1));
        if (reduce.isPresent()) {
            return (IndependentClause)reduce.get();
        }
        return null;
    }
}

