/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Person;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.text.Text;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class GroupedCollectionNounPhrase
implements NounPhrase {
    private final List<NounPhrase> nounPhraseList = new ArrayList<NounPhrase>();
    private final String value;
    private final Number number;

    public static GroupedCollectionNounPhrase create(Collection<? extends NounPhrase> nounPhraseList) {
        GroupedCollectionNounPhrase obj = new GroupedCollectionNounPhrase(nounPhraseList);
        if (obj.value == null) {
            return null;
        }
        return obj;
    }

    private GroupedCollectionNounPhrase(Collection<? extends NounPhrase> nounPhraseList) {
        this.nounPhraseList.addAll(nounPhraseList);
        ArrayList<String> nounStrings = new ArrayList<String>();
        Map<String, List<NounPhrase>> groups = GroupedCollectionNounPhrase.groupNounsByDescriptionIntoMap(this.nounPhraseList);
        if (groups.isEmpty()) {
            this.value = null;
            this.number = Number.Singular;
            return;
        }
        ArrayList numbers = new ArrayList();
        groups.forEach((k, group) -> {
            NounPhrase groupExample = (NounPhrase)group.get(0);
            if (group.size() == 1) {
                nounStrings.add(NounPhraseWithArticle.a(groupExample).toString());
                numbers.add(groupExample.getNumber());
            } else {
                nounStrings.add(group.size() + " " + groupExample.as(Number.Plural).toString());
                numbers.add(Number.Plural);
            }
        });
        this.number = numbers.isEmpty() ? Number.Singular : (Number)((Object)numbers.get(0));
        this.value = Text.toStringListWithAnd(nounStrings);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Number getNumber() {
        return this.number;
    }

    @Override
    public Person getPerson() {
        return this.nounPhraseList.isEmpty() ? Person.ThirdPerson : this.nounPhraseList.get(0).getPerson();
    }

    @Override
    public boolean isCountNoun() {
        return false;
    }

    @Override
    public NounPhrase as(Number number) {
        throw new NotImplementedException();
    }

    private static Map<String, List<NounPhrase>> groupNounsByDescriptionIntoMap(List<NounPhrase> nouns) {
        HashMap<String, List<NounPhrase>> groups = new HashMap<String, List<NounPhrase>>();
        for (NounPhrase noun : nouns) {
            if (noun == null) continue;
            String descr = noun.toString();
            if (!groups.containsKey(descr)) {
                groups.put(descr, new ArrayList());
            }
            ((List)groups.get(descr)).add(noun);
        }
        return groups;
    }

    @Override
    public TextMatcher.Result matches(String[] words, int startIndex, Frame frame) {
        throw new RuntimeException("No intentions of ever implementing this although it coudl be done.");
    }
}

