/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.wearabililty.WearabilityState;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import java.util.List;
import java.util.stream.Collectors;

public class WearCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0 || !words[0].toLowerCase().equals("wear")) {
            return null;
        }
        if (words.length == 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        Frame frame = context.simulation.getCurrentFrame();
        Inventory inventory = InventoryState.get(frame).get(context.player);
        if (inventory == null) {
            return this.failWithBadObjectHint();
        }
        List<Noun> nounsWeMightWear = inventory.getItems();
        List results = AbstractCommand.matchOne(words, 1, nounsWeMightWear, context.player, frame).stream().filter(result -> result.getStartIndex() + result.getNumWordsMatched() == words.length).collect(Collectors.toList());
        if (results.isEmpty()) {
            return this.failWithBadObjectHint();
        }
        return new ActionsAndHints(results.stream().map(tmResult -> new Result((Noun)tmResult.data, context)).collect(Collectors.toList()));
    }

    @Override
    public String getHelpString() {
        return "Type 'wear' followed by the name of a piece of clothing in your inventory.  For instance 'wear hat'.";
    }

    @Override
    public String getNameString() {
        return "wear";
    }

    @Override
    public String getPurposeString() {
        return "Wear a piece of clothing.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you're trying to wear.");
    }

    public static final class Result
    implements UserAction {
        private final Noun thingToWear;
        private final Command.Context context;

        public Result(Noun thingToWear, Command.Context context) {
            this.thingToWear = thingToWear;
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to wear " + NounPhraseWithArticle.a(this.thingToWear.getContextFreeDescription());
        }

        @Override
        public void execute(TextAppController controller) {
            Frame frame = this.context.simulation.getCurrentFrame();
            WearableCategory category = WearabilityState.get(frame).getWearableCategory(this.thingToWear);
            if (category == null) {
                PlayerNotificationEvent.postAlwaysPerceivable("You can't wear that.", this.context);
                return;
            }
            PlayerNotificationEvent.postAlwaysPerceivable("You wear " + NounPhraseWithArticle.the(this.thingToWear.getDefaultPerception(frame)) + ".", this.context);
            InventoryState.requestWearItem(this.context.player, this.thingToWear, category, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

