/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.states.singleplayer.WaitState;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.DelayedUpdateable;
import com.fabriziopolo.textcraft.states.updatable.UpdateableState;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;

public class WaitCommand
implements Command {
    private static final List<String> WAIT_SYNONYMS = Arrays.asList("wait", "z");

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        if (!WAIT_SYNONYMS.contains(words[0].toLowerCase())) {
            return null;
        }
        if (words.length > 2) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        int hoursToWait = 3;
        if (words.length == 2) {
            try {
                hoursToWait = Integer.parseInt(words[1]);
                if (hoursToWait <= 0) {
                    return ActionsAndHints.hint("Very clever.  Did you think you might time travel?");
                }
            }
            catch (Exception ex) {
                return ActionsAndHints.hint(this.getHelpString());
            }
        }
        return ActionsAndHints.action(new Result(hoursToWait, context));
    }

    @Override
    public String getHelpString() {
        return "Type 'wait' to cause time to accelerate for a while (3 hours).  If you are injured time will immediately resume normal speed.  Specify the number of hours you'd like to wait after the word 'wait' if you like.  E.g. 'wait 6' will cause time to accelerate until six hours have passed.";
    }

    @Override
    public String getNameString() {
        return "wait";
    }

    @Override
    public String getPurposeString() {
        return "Let time pass. (z)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private static class Result
    implements UserAction {
        private final int numHoursToWait;
        private final Command.Context context;

        private Result(int numHoursToWait, Command.Context context) {
            this.numHoursToWait = numHoursToWait;
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "wait for " + this.numHoursToWait + " hours";
        }

        @Override
        public void execute(TextAppController controller) {
            TimeState timeState = TimeState.get(this.context.simulation.getCurrentFrame());
            WaitState.requestWait(this.context.player, this.context.simulation);
            ZonedDateTime now = timeState.getGameTime();
            DelayedUpdateable stopWaitingUpdate = new DelayedUpdateable(now.plusHours(this.numHoursToWait).toInstant(), (noun, simulation) -> {
                if (WaitState.get(simulation.getCurrentFrame()).isWaiting(this.context.player)) {
                    TimeState futureTimeState = TimeState.get(this.context.simulation.getCurrentFrame());
                    WaitState.requestStopWaiting(this.context.player, simulation);
                }
                UpdateableState.requestRemoveUpdateable(noun, simulation);
            });
            UpdateableState.requestSetUpdateable(new EmptyNoun(), stopWaitingUpdate, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

