/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.position.PlayerExaminesSurroundingsEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import java.util.ArrayList;

public class LookCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length != 1) {
            return null;
        }
        String word = words[0].toLowerCase();
        if (word.equals("l") || word.equals("look")) {
            ArrayList<Result> results = new ArrayList<Result>();
            results.add(new Result(context));
            return new ActionsAndHints(results);
        }
        return null;
    }

    @Override
    public String getHelpString() {
        return "Type 'look' to examine your surroundings.  Type 'look' followed by a direction to look in that direction. For instance, 'look' or 'look east'.";
    }

    @Override
    public String getNameString() {
        return "look";
    }

    @Override
    public String getPurposeString() {
        return "Look around \"look\" or look in a direction \"look west\". (l)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    class Result
    implements UserAction {
        private final Command.Context context;

        private Result(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to look at your surroundings";
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerExaminesSurroundingsEvent.post(this.context);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

