/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.text.Text;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.StringUtils;

public final class HelpCommand
implements Command {
    private static final List<String> HELP_SYNONYMS = Arrays.asList("help", "h", "?");
    private final List<Command> allCommands;

    public HelpCommand(List<Command> allCommands) {
        this.allCommands = allCommands.stream().filter(command -> command.isVisibleInHelp()).collect(Collectors.toList());
        if (this.isVisibleInHelp()) {
            this.allCommands.add(this);
        }
    }

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        ActionsAndHints resultsAndHints = new ActionsAndHints();
        if (words.length == 0) {
            return null;
        }
        String commandWord = words[0].toLowerCase();
        if (!HELP_SYNONYMS.contains(commandWord)) {
            return null;
        }
        if (words.length == 1) {
            resultsAndHints.addAction(new ListCommandsHelpResult(context));
        } else if (words.length > 2) {
            resultsAndHints.addHint(this.getHelpString());
        } else {
            String maybeCommandName = words[1].toLowerCase();
            boolean foundCommandName = false;
            for (Command command : this.allCommands) {
                String nameString = command.getNameString();
                if (nameString == null || !maybeCommandName.equals(nameString.toLowerCase())) continue;
                resultsAndHints.addAction(new SpecificCommandHelpResult(context, command));
                foundCommandName = true;
            }
            if (!foundCommandName) {
                resultsAndHints.addHint("That isn't a command I recognize. " + this.getHelpString());
            }
        }
        return resultsAndHints;
    }

    @Override
    public String getHelpString() {
        return "Type 'help' or '?' to get a list of all commands.  Type 'help' followed by the name of a command for more information.  For even more information type 'wiki' to visit the wiki.\n";
    }

    @Override
    public String getNameString() {
        return "help";
    }

    @Override
    public String getPurposeString() {
        return "Get help about all commands or a particular command. (?)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    public final class SpecificCommandHelpResult
    extends Result {
        private final Command commandToGetHelpAbout;

        public SpecificCommandHelpResult(Command.Context context, Command commandToGetHelpAbout) {
            super(context);
            this.commandToGetHelpAbout = commandToGetHelpAbout;
        }

        @Override
        public String getDescription() {
            if (this.commandToGetHelpAbout.getNameString() != null) {
                return "to get help about the " + this.commandToGetHelpAbout.getNameString() + " command";
            }
            return "to get help";
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerNotificationEvent.postAlwaysPerceivable(this.commandToGetHelpAbout.getHelpString(), this.context);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }

    public final class ListCommandsHelpResult
    extends Result {
        public ListCommandsHelpResult(Command.Context context) {
            super(context);
        }

        @Override
        public String getDescription() {
            return "to get a list of all commands";
        }

        @Override
        public void execute(TextAppController controller) {
            StringBuilder msg = new StringBuilder();
            msg.append(HelpCommand.this.getHelpString());
            msg.append(Text.getLineSeparator());
            int maxNameLength = (Integer)Collections.max(HelpCommand.this.allCommands.stream().map(command -> command.getNameString() == null ? 0 : command.getNameString().length()).sorted().collect(Collectors.toSet()));
            HelpCommand.this.allCommands.forEach(command -> {
                if (command.isVisibleInHelp()) {
                    String name = command.getNameString();
                    msg.append(StringUtils.repeat(" ", maxNameLength - name.length()));
                    msg.append(name);
                    msg.append(" - ");
                    msg.append(command.getPurposeString());
                    msg.append(Text.getLineSeparator());
                }
            });
            PlayerNotificationEvent.postAlwaysPerceivable(msg.toString(), this.context);
        }

        @Override
        public boolean isValid(Frame frame) {
            return false;
        }
    }

    public abstract class Result
    implements UserAction {
        protected final Command.Context context;

        protected Result(Command.Context context) {
            this.context = context;
        }

        @Override
        public boolean isValid(Frame frame) {
            return false;
        }
    }
}

