/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.states.position.updates.PlayerGoDirectionRequest;
import com.fabriziopolo.textcraft.text.Text;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class GoCommand
extends AbstractCommand {
    private static final List<String> GO_SYNONYMS = Arrays.asList("go", "g");

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        int idx = 0;
        if (GO_SYNONYMS.contains(words[idx].toLowerCase())) {
            ++idx;
        }
        ActionsAndHints results = new ActionsAndHints();
        results.addAll(this.parseGoDirection(words, idx, context));
        if (results.hints.isEmpty() && idx == 1) {
            results.addHint(this.getHelpString());
        }
        return results;
    }

    @Override
    public String getHelpString() {
        return "The 'go' command let's you move in a direction or move in relation to an object." + Text.getLineSeparator() + Text.getLineSeparator() + this.getGoDirectionHint() + Text.getLineSeparator() + Text.getLineSeparator() + this.getGoPrepositionHint();
    }

    @Override
    public String getNameString() {
        return "go";
    }

    @Override
    public String getPurposeString() {
        return "Walk/swim/climb in a direction or go in/up/on... things. (n/s/e/w)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private String getGoDirectionHint() {
        return "To walk/swim/climb in a direction just type 'go' followed by the name of the direction: 'north', 'south', 'east', 'west', 'up', 'down').  The word 'go' is optional.  You can just type the direction.  Also you can abbreviate directions n, s, e, w, u, d.";
    }

    private String getGoPrepositionHint() {
        return "'go under water', 'go in shed', and 'go up tree' are all examples of moving in relation to another object. In general type 'go <preposition> <thing>'.  If you're already under/in/up... something, you can just type the reverse preposition to get out: 'out', 'down', etc.  The 'look' command will always show you the exits.  In all cases the word 'go' is optional.  For instance, 'up tree', or 'out' will be understood.";
    }

    private ActionsAndHints parseGoDirection(String[] words, int idx, Command.Context context) {
        Frame frame = context.simulation.getCurrentFrame();
        List<Noun> allDirections = Directions.get(frame).getAll();
        List<TextMatcher.ResultWithData<Noun>> directionMatches = GoCommand.matchOne(words, idx, allDirections, context.player, frame);
        directionMatches = directionMatches.stream().filter(match -> match.getEndIndex() == words.length).collect(Collectors.toList());
        ActionsAndHints results = new ActionsAndHints();
        directionMatches.forEach(match -> results.addAction(new GoDirectionResult(context, (Noun)match.data)));
        return results;
    }

    private ActionsAndHints parseGoPreposition(String[] words, int idx, Command.Context context) {
        Frame frame = context.simulation.getCurrentFrame();
        List<TextMatcher.ResultWithData<Preposition>> prepositionMatches = GoCommand.matchOne(words, idx, Prepositions.getAllPrepositions(), frame);
        if (prepositionMatches.isEmpty()) {
            return null;
        }
        List<Noun> perceivableNouns = context.player.getPerceivableNouns(frame);
        List<TextMatcher.ResultWithData<Noun>> nounMatches = GoCommand.matchOne(words, idx, perceivableNouns, context.player, frame);
        if (nounMatches.isEmpty()) {
            return ActionsAndHints.hint(this.getGoPrepositionHint());
        }
        Object spot = null;
        return null;
    }

    class GoPrepositionResult
    implements UserAction {
        private final Command.Context context;
        private final Preposition preposition;
        private final Noun spot;

        private GoPrepositionResult(Command.Context context, Preposition preposition, Noun spot) {
            this.context = context;
            this.preposition = preposition;
            this.spot = spot;
        }

        @Override
        public String getDescription() {
            NounPhrase perceptionOfSpot = this.context.player.getPerceptionOf(this.spot, this.context.simulation.getCurrentFrame());
            if (perceptionOfSpot == null) {
                return "to go " + this.preposition + ".";
            }
            return "to go " + this.preposition + " " + NounPhraseWithArticle.the(perceptionOfSpot) + ".";
        }

        @Override
        public void execute(TextAppController controller) {
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }

    class GoDirectionResult
    implements UserAction {
        private final Command.Context context;
        private final Noun direction;

        private GoDirectionResult(Command.Context context, Noun direction) {
            this.context = context;
            this.direction = direction;
        }

        @Override
        public String getDescription() {
            return "to walk " + this.context.player.getPerceptionOf(this.direction, this.context.simulation.getCurrentFrame());
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerGoDirectionRequest.makeRequest(this.direction, this.context);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

