/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.position.PlayerExaminesNounEvent;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.text.Text;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.List;
import java.util.stream.Collectors;

public class ExamineCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length < 1) {
            return null;
        }
        int idx = 0;
        boolean foundExamineWord = false;
        String firstWord = words[idx].toLowerCase();
        if (firstWord.equals("x") || firstWord.equals("examine")) {
            ++idx;
            foundExamineWord = true;
        }
        if (words.length == idx) {
            return this.failWithHint();
        }
        Frame frame = context.simulation.getCurrentFrame();
        List<Noun> nouns = this.getObjectToExamine(words, idx, this.getAccessibleNouns(context.player, frame), context.player, frame);
        if (nouns.size() == 0) {
            if (foundExamineWord) {
                return this.failWithBadObjectHint();
            }
            return null;
        }
        return new ActionsAndHints(nouns.stream().map(noun -> new Result(context, (Noun)noun)).collect(Collectors.toList()));
    }

    @Override
    public String getHelpString() {
        return "To examine an object just type its name.  You can also type 'examine' or 'x' followed by the name of the thing you'd like to examine.  For example 'tree' or 'examine tree'.";
    }

    @Override
    public String getNameString() {
        return "examine";
    }

    @Override
    public String getPurposeString() {
        return "Examine an object. (x)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private ActionsAndHints failWithHint() {
        return ActionsAndHints.hint(this.getHelpString());
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you're trying to examine.");
    }

    private List<Noun> getAccessibleNouns(Player player, Frame frame) {
        List<Noun> perceivableNouns = player.getPerceivableNouns(frame);
        return Text.chooseRepresentativesByDescription(perceivableNouns, player, frame);
    }

    private List<Noun> getObjectToExamine(String[] words, int idx, List<Noun> nouns, Perceiver player, Frame frame) {
        return nouns.stream().filter(noun -> {
            TextMatcher.Result matches = noun.matches(words, idx, player, frame);
            return matches.isMatch && matches.getEndIndex() == words.length;
        }).collect(Collectors.toList());
    }

    class Result
    implements UserAction {
        private final Command.Context context;
        private final Noun objectToExamine;

        private Result(Command.Context context, Noun objectToExamine) {
            this.context = context;
            this.objectToExamine = objectToExamine;
        }

        @Override
        public String getDescription() {
            return "to examine " + NounPhraseWithArticle.the(this.context.player.getPerceptionOf(this.objectToExamine, this.context.simulation.getCurrentFrame()));
        }

        @Override
        public void execute(TextAppController controller) {
            this.context.simulation.postEvent(new PlayerExaminesNounEvent(this.objectToExamine));
        }

        @Override
        public boolean isValid(Frame frame) {
            return ExamineCommand.this.getAccessibleNouns(this.context.player, frame).contains(this.objectToExamine);
        }
    }
}

