/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.PureIndependentClause;
import com.fabriziopolo.textcraft.nlg.VerbPhrase;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.edibility.EatHandler;
import com.fabriziopolo.textcraft.states.edibility.EdibilityData;
import com.fabriziopolo.textcraft.states.edibility.EdibilityState;
import com.fabriziopolo.textcraft.states.edibility.EdibleEffect;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.text.Text;
import java.util.List;
import java.util.stream.Collectors;

public class EatCommand
implements Command {
    private final VerbPhrase toEat = Nlg.pureVerb("eat", "eat", "eats", "eat");
    private final VerbPhrase toDrink = Nlg.pureVerb("drink", "drink", "drinks", "drink");
    VerbPhrase consumptionVerb;
    String pastTenseOfConsumptionVerb;
    boolean includesFrom = false;

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        Frame frame;
        List<Noun> accessibleNouns;
        List<Noun> objectsToEat;
        if (words.length == 0) {
            return null;
        }
        String firstWord = words[0].toLowerCase();
        if (firstWord.equals(this.toEat.toString())) {
            this.consumptionVerb = this.toEat;
            this.pastTenseOfConsumptionVerb = "ate";
        } else if (firstWord.equals(this.toDrink.toString())) {
            this.consumptionVerb = this.toDrink;
            this.pastTenseOfConsumptionVerb = "drank";
        } else {
            return null;
        }
        if (words.length == 1) {
            return this.failWithHint();
        }
        int idx = 1;
        String word1 = words[1].toLowerCase();
        if (word1.equals("from")) {
            this.includesFrom = true;
            if (words.length == ++idx) {
                return this.failWithEatFromHint();
            }
        }
        if ((objectsToEat = this.getObjectToEat(words, idx, accessibleNouns = this.getAccessibleNouns(context.player, frame = context.simulation.getCurrentFrame()), context.player, frame)).size() == 0) {
            return this.failWithBadObjectHint();
        }
        List objectsToEatInInventory = objectsToEat.stream().filter(noun -> InventoryState.isInInventory(context.player, noun, frame)).collect(Collectors.toList());
        if (!objectsToEatInInventory.isEmpty()) {
            objectsToEat = objectsToEatInInventory;
        }
        objectsToEat = Text.chooseRepresentativesByDescription(objectsToEat, context.player, frame);
        ActionsAndHints resultsAndHints = new ActionsAndHints(objectsToEat.stream().map(noun -> new Result(context, (Noun)noun)).collect(Collectors.toList()));
        return resultsAndHints;
    }

    private ActionsAndHints failWithHint() {
        return ActionsAndHints.hint(this.getHelpString());
    }

    private ActionsAndHints failWithEatFromHint() {
        return ActionsAndHints.hint("What are you trying to " + this.consumptionVerb + " from?");
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you are trying to " + this.consumptionVerb + ".");
    }

    @Override
    public String getHelpString() {
        return "Type 'eat' or 'drink' followed by the thing you want to eat or drink.";
    }

    @Override
    public String getNameString() {
        return "eat";
    }

    @Override
    public String getPurposeString() {
        return "Consume food and drink. (eat/drink)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private List<Noun> getAccessibleNouns(Player player, Frame frame) {
        List<Noun> perceivableNouns = player.getPerceivableNouns(frame);
        return perceivableNouns;
    }

    private List<Noun> getObjectToEat(String[] words, int idx, List<Noun> nouns, Perceiver player, Frame frame) {
        return nouns.stream().filter(noun -> noun.matches((String[])words, (int)idx, (Perceiver)player, (Frame)frame).isMatch).collect(Collectors.toList());
    }

    private static class DefaultEatHandler
    implements EatHandler {
        private final String consumptionWord;

        private DefaultEatHandler(String consumptionWord) {
            this.consumptionWord = consumptionWord;
        }

        @Override
        public void handleEat(Noun consumer, Noun consumed, EdibleEffect effect, Simulation simulation) {
            InventoryState.requestRemoveItem(consumer, consumed, simulation);
            PositionState.requestRemove(consumed, simulation);
        }
    }

    class Result
    implements UserAction {
        private final Command.Context context;
        private final Noun objectToEat;

        private Result(Command.Context context, Noun objectToEat) {
            this.context = context;
            this.objectToEat = objectToEat;
        }

        @Override
        public String getDescription() {
            return "to " + EatCommand.this.consumptionVerb + " " + this.context.player.getPerceptionOf(this.objectToEat, this.context.simulation.getCurrentFrame());
        }

        @Override
        public void execute(TextAppController controller) {
            Frame frame = this.context.simulation.getCurrentFrame();
            EdibilityData data = EdibilityState.get(frame).get(this.objectToEat);
            if (data == null) {
                PlayerNotificationEvent.postAlwaysPerceivable("That isn't edible.", this.context);
            } else {
                EatHandler handler;
                String youEatTheThingPlayerMessage = "you " + EatCommand.this.consumptionVerb + " " + NounPhraseWithArticle.the(this.context.player.getPerceptionOf(this.objectToEat, frame));
                PlayerNotificationEvent.postAlwaysPerceivable(Nlg.literalClauseSentence(youEatTheThingPlayerMessage).toString(), this.context);
                String youEatTheThingCause = "you " + EatCommand.this.pastTenseOfConsumptionVerb + " " + NounPhraseWithArticle.the(this.context.player.getPerceptionOf(this.objectToEat, frame));
                if (data.effect != null) {
                    data.effect.onConsumption(this.context.simulation, this.context.player, this.objectToEat, new PureIndependentClause(youEatTheThingCause));
                }
                if ((handler = data.handler) == null) {
                    handler = new DefaultEatHandler(EatCommand.this.consumptionVerb.toString());
                }
                handler.handleEat(this.context.player, this.objectToEat, data.effect, this.context.simulation);
            }
        }

        @Override
        public boolean isValid(Frame frame) {
            return EatCommand.this.getAccessibleNouns(this.context.player, frame).contains(this.objectToEat);
        }
    }
}

