/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app.menu;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.NumericTextMenu;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.menu.LaunchWikiMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.NewCampaignMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.NewGameMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.SaveMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.ShowLoadMenuMenuOptionAction;
import com.fabriziopolo.textcraft.app.menu.SwitchCampaignMenuMenuOptionAction;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.peristence.Campaign;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;

public class MainGameMenuBuilder {
    private final TextAppController controller;
    private final Supplier<SinglePlayerGameState> gameStateSupplier;

    public MainGameMenuBuilder(TextAppController controller, Supplier<SinglePlayerGameState> gameStateSupplier) {
        this.controller = Objects.requireNonNull(controller);
        this.gameStateSupplier = gameStateSupplier;
    }

    public NumericTextMenu build() {
        ArrayList<UserAction> options = new ArrayList<UserAction>();
        Campaign campaign = this.controller.getCampaign();
        if (campaign != null) {
            options.add(new SaveMenuOptionAction());
            options.add(new ShowLoadMenuMenuOptionAction(campaign, this.gameStateSupplier));
            options.add(new NewGameMenuOptionAction(campaign, this.gameStateSupplier));
        }
        options.add(new NewCampaignMenuOptionAction(this.gameStateSupplier));
        options.add(new SwitchCampaignMenuMenuOptionAction(this.gameStateSupplier));
        options.add(new LaunchWikiMenuOptionAction());
        String title = campaign != null ? "-- " + this.controller.getGame().getFullGameName() + " - " + campaign.campaignDisplayName + " --" : "-- " + this.controller.getGame().getFullGameName() + " --";
        return new NumericTextMenu(title, options, this.controller.getTxt(), true);
    }
}

