/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app;

import com.fabriziopolo.textapp.InteractiveTextUi;
import com.fabriziopolo.textapp.InteractiveTextUiFake;
import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.Game;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.StatefulParserExecutor;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.app.TextPrinterImpl;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.peristence.Persistence;
import com.fabriziopolo.textcraft.peristence.Script;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.states.singleplayer.EndGameState;
import com.fabriziopolo.textcraft.text.FrameRenderer;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class TextCraftAppControllerFake
implements TextAppController {
    private static final int consoleWidth = 84;
    private static final int consoleHeight = 40;
    private static final int margin = 2;
    private static final FrameRenderer renderer = new FrameRenderer(80, 40);
    private Game game;
    private Campaign campaign = null;
    private SinglePlayerGameState gameState = null;
    private StatefulParserExecutor parserExecutor = new StatefulParserExecutor();
    private InteractiveTextUiFake uiFake = null;
    private TextPrinter txt = null;

    public TextCraftAppControllerFake(Game game, Script script) {
        this.setGame(game);
        this.setUi(new InteractiveTextUiFake(script));
    }

    public void play() {
    }

    @Override
    public void onText(String input) {
        this.executeInSimulation(simulation -> {
            if (this.parseAppLevelCommands(input)) {
                return;
            }
            boolean didAction = this.parserExecutor.onParsedInput(input, this);
        });
    }

    @Override
    public void setUi(InteractiveTextUi ui) {
        this.uiFake = (InteractiveTextUiFake)ui;
        this.uiFake.setInputListener(this);
        this.txt.setTextListener(ui);
        ui.setTitle(this.getFullExperienceTitle());
    }

    public Frame pump() {
        SinglePlayerSimulation simulation = this.gameState.getSimulation();
        this.uiFake.onFrame(simulation.getCurrentFrame());
        Frame prevFrame = simulation.getCurrentFrame();
        simulation.update();
        this.onFrame(simulation, prevFrame);
        return simulation.getCurrentFrame();
    }

    private boolean parseAppLevelCommands(String userInput) {
        String scriptFileName = "script.bin";
        return (userInput = userInput.toLowerCase()).equals("save script");
    }

    private boolean onFrame(SinglePlayerSimulation simulation, Frame prevFrame) {
        boolean isSimulationEnded = this.renderCurrentFrame(simulation, simulation.player);
        this.applyExternalSimulationUpdateSideEffects(prevFrame, simulation.getCurrentFrame());
        if (isSimulationEnded) {
            this.onSimulationEndedInternally(simulation);
        }
        return isSimulationEnded;
    }

    private void onSimulationEndedInternally(SinglePlayerSimulation simulation) {
        this.txt.println("(press enter to continue)");
        this.uiFake.clearInput();
        this.uiFake.requireInput(ignore -> this.play());
    }

    private boolean renderCurrentFrame(Simulation simulation, Player player) {
        Frame frame = simulation.getCurrentFrame();
        renderer.startRendering(frame, player, this.txt);
        while (renderer.isBlocked()) {
            renderer.continueRendering(this.txt);
        }
        return EndGameState.isGameEnded(frame);
    }

    private void applyExternalSimulationUpdateSideEffects(Frame prevFrame, Frame frame) {
        if (this.gameState == null) {
            return;
        }
    }

    private String getFullExperienceTitle() {
        if (this.campaign != null) {
            return this.game.getFullGameName() + " - v" + this.game.getVersion() + " - " + this.campaign.campaignDisplayName;
        }
        return this.game.getFullGameName() + " - v" + this.game.getVersion();
    }

    @Override
    public void setGame(Game game) {
        this.game = Objects.requireNonNull(game);
        this.txt = new TextPrinterImpl(2, 82, null);
        this.txt.setTextListener(this.uiFake);
        this.setCampaign(null);
    }

    @Override
    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
        if (this.uiFake != null) {
            this.uiFake.setTitle(this.getFullExperienceTitle());
        }
    }

    @Override
    public void setGameState(SinglePlayerGameState gameState) {
        this.gameState = gameState;
        this.parserExecutor = new StatefulParserExecutor();
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public Campaign getCampaign() {
        return this.campaign;
    }

    @Override
    public SinglePlayerGameState getGameState() {
        return this.gameState;
    }

    @Override
    public StatefulParserExecutor getParserExecutor() {
        return this.parserExecutor;
    }

    @Override
    public InteractiveTextUi getUi() {
        return this.uiFake;
    }

    @Override
    public Persistence getPersistence() {
        return null;
    }

    @Override
    public TextPrinter getTxt() {
        return this.txt;
    }

    @Override
    public void executeInSimulation(Consumer<Simulation> doMe) {
        doMe.accept(this.gameState.getSimulation());
    }

    @Override
    public void onClose(boolean save) {
        this.txt.closeLog();
    }

    public List<String> getPostedText() {
        return this.uiFake.getPostedText();
    }
}

