/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.FlowSetupDialog;
import GuiTool.Gui.InputOptionDialog;
import GuiTool.Gui.InputPanel;
import GuiTool.Gui.LvgMenu;
import GuiTool.Gui.LvgPopupMenu;
import GuiTool.Gui.MainPanel;
import GuiTool.Gui.MutateOptionDialog;
import GuiTool.Gui.MutatePanel;
import GuiTool.Gui.OutputOptionDialog;
import GuiTool.Gui.OutputPanel;
import GuiTool.GuiLib.LibCloseableFrame;
import GuiTool.GuiLib.LvgHtmlBrowser;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LvgFrame
extends LibCloseableFrame
implements ActionListener {
    private static boolean showCmd_ = true;
    private static boolean setCmdEditable_ = false;
    private static boolean bold_ = false;
    private static boolean italic_ = false;
    private static String style_ = "Dialog";
    private static int size_ = 12;
    private static MainPanel mainPanel_ = null;
    private static JFrame lvgFrame_ = null;
    private static LvgHtmlBrowser helpDoc_ = null;
    private static final long serialVersionUID = 5L;

    public LvgFrame() {
        lvgFrame_ = this;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        this.setTitle("Lexical Tool");
        this.setSize(600, 650);
        this.setLocation(5, 10);
        this.setResizable(true);
        Image img = tk.getImage("./data/image/lvg.jpg");
        this.setIconImage(img);
        LvgPopupMenu.AddPopupMenu(this);
        LvgMenu.AddMenu(this);
        mainPanel_ = new MainPanel(this);
        this.getContentPane().add(mainPanel_);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        if (arg.equals("Exit")) {
            if (LvgGlobal.lvg_ != null) {
                LvgGlobal.lvg_.CleanUp();
            }
            System.exit(0);
        } else if (arg.equals("Input File")) {
            JFileChooser dialog = new JFileChooser();
            dialog.setSelectedFile(LvgGlobal.inFile_);
            dialog.setDialogTitle("Choose the input file");
            dialog.setMultiSelectionEnabled(false);
            if (dialog.showDialog(this, "Select") == 0) {
                LvgGlobal.inFile_ = dialog.getSelectedFile();
                InputPanel.SetFile(LvgGlobal.inFile_.getPath());
            }
        } else if (arg.equals("Output File")) {
            JFileChooser dialog = new JFileChooser();
            dialog.setSelectedFile(LvgGlobal.outFile_);
            dialog.setDialogTitle("Choose the output file");
            dialog.setMultiSelectionEnabled(false);
            if (dialog.showDialog(this, "Select") == 0) {
                LvgGlobal.outFile_ = dialog.getSelectedFile();
                OutputOptionDialog.SetOutputFile(LvgGlobal.outFile_);
            }
        } else if (arg.equals("Flow Setup")) {
            FlowSetupDialog.ShowDialog(this);
        } else if (arg.equals("Input Options")) {
            InputOptionDialog.ShowDialog(lvgFrame_);
        } else if (arg.equals("Mutate Options")) {
            MutateOptionDialog.ShowDialog(lvgFrame_);
        } else if (arg.equals("Output Options")) {
            OutputOptionDialog.ShowDialog(lvgFrame_);
        } else if (arg.equals("Show Commands")) {
            showCmd_ = !showCmd_;
            MutatePanel.SetShowCommand(showCmd_);
        } else if (arg.equals("Set Commands Editable")) {
            setCmdEditable_ = !setCmdEditable_;
            MutatePanel.SetCommandEditable(setCmdEditable_);
        } else if (arg.equals("Serif") || arg.equals("SansSerif") || arg.equals("Monospaced") || arg.equals("Dialog") || arg.equals("DialogInput")) {
            style_ = arg;
            this.UpdateFont();
        } else if (arg.equals("Bold")) {
            bold_ = !bold_;
            this.UpdateFont();
        } else if (arg.equals("Italic")) {
            italic_ = !italic_;
            this.UpdateFont();
        } else if (arg.equals("8") || arg.equals("10") || arg.equals("12") || arg.equals("14") || arg.equals("16") || arg.equals("18") || arg.equals("20") || arg.equals("24") || arg.equals("28") || arg.equals("32")) {
            size_ = Integer.parseInt(arg);
            this.UpdateFont();
        } else if (arg.equals("Metal")) {
            String laf = "javax.swing.plaf.metal.MetalLookAndFeel";
            this.UpdateLookAndFeel(laf, this);
        } else if (arg.equals("Motif")) {
            String laf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            this.UpdateLookAndFeel(laf, this);
        } else if (arg.equals("Window")) {
            String laf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            this.UpdateLookAndFeel(laf, this);
        } else if (arg.equals("About")) {
            JOptionPane.showMessageDialog(this, "Lexical Tools 2011", "About Lexical Tool", 1);
        } else if (arg.equals("Documents")) {
            String lvgDir = LvgGlobal.config_.GetConfiguration("LVG_DIR");
            String docUrl = "file:" + lvgDir + "docs/designDoc/UDF/gui/index.html";
            if (helpDoc_ == null) {
                String title = "Lexical GUI Tool Documents";
                String homeUrl = "file:" + lvgDir + "docs/designDoc/UDF/gui/index.html";
                helpDoc_ = new LvgHtmlBrowser(this, title, 600, 800, homeUrl, docUrl);
            } else {
                helpDoc_.SetPage(docUrl);
            }
            helpDoc_.setVisible(true);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    public static boolean GetShowCmd() {
        return showCmd_;
    }

    public static boolean GetSetCmdEditable() {
        return setCmdEditable_;
    }

    private void UpdateFont() {
        Font font = new Font(style_, (bold_ ? 1 : 0) + (italic_ ? 2 : 0), size_);
        InputPanel.GetTermField().setFont(font);
        MutatePanel.GetCmdField().setFont(font);
        OutputPanel.GetOutputList().setFont(font);
        this.repaint();
    }

    private void UpdateLookAndFeel(String laf, JFrame frame) {
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(frame);
        }
        catch (Exception e) {
            System.out.println("-- This platform does not support: " + laf);
        }
    }
}

