require_relative "../classes.rb"


class TestWorldBehavior < BaseBehaviorTestCase 
  attr_accessor :world

  def setup
    super
    @subject = Traveller.new.subscribe!
    test_init_gauges
  end

  def test_object_removed_on_removed
    assert_not_nil @subject
    e = AR::Events::ObjectRemovedFromGame.new ar_object: @subject
    assert !(e.engine.subscriptions & @subject.subscriptions).empty?
    assert_not_nil (world.find @subject.id)
    e.resolve!
    assert_empty(e.engine.subscriptions & @subject.subscriptions)
    assert_nil (world.find @subject.id)
  end


    

=begin
  def test_load_and_unload_should_be_inverse_functions
    d = AR::Game::WorldBehavior.unload_data world
    world.day = -1 
    world.time = -1 
    world.world_name = "testvs"
    AR::Game::WorldBehavior.load_data world, d 
    assert_not_equal world.world_name, "testvs"
    assert_not_equal world.day, -1 
    assert_not_equal world.time, -1 
  end
=end

end
