require "./lib/apocrodentia"
require "test/unit"
require_relative "../classes.rb"

class TestNpcDialogBehavior < Test::Unit::TestCase 
  attr_accessor :world
  include TestTypes
  extend AR::Events

  def setup
    self.world = World.new
    AR::Game::Behavior.set_world self.world
    @subject = Traveller.new
    @player = Player.new
    @subject.root_dialog_node_class = AR::Game::NpcDialogBehavior::ExampleNode
    @test_serialized_data = {root_dialog_node_class: AR::Game::NpcDialogBehavior::ExampleNode}
  end

  def test_npc_dialog_node_presented_is_released_on_dialog_began_event
    e = @subject.create AR::Events::DialogBeganEvent, player: @player, npc: @subject
    results = e.resolve!
    dnp = results.select{|e| e.class == AR::Events::DialogNodeActivatedEvent}.last
    assert_not_nil dnp
    assert_equal @subject, dnp.npc 
    assert_equal @subject.root_dialog_node_class, dnp.dialog_node.class
  end


end

