module AR::Game::PlayerControl 

  def name
    "you"
  end

  def self.init ar_object 
    ar_object.ownership = "your"
  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions   << self.choose_action
    ar_object.resolutions   << self.choose_reaction
    ar_object.subscriptions<< self.reprint_on_clock_tick(ar_object)
  end 

  def self.reprint_on_action_begun playr
    AR::Events::Subscription.new event_class: AR::Events::ActionBeganEvent do |e| 
      playr.printer.reprint_cache! if playr == e.performer
    end
  end


  def self.reprint_on_clock_tick playr
    AR::Events::Subscription.new event_class: AR::Events::ClockTickEvent do |e| 
      printer = playr.printer
      printer.reprint_cache! 
    end
  end


  def self.choose_action 
    AR::Events::Resolution.new event_class: AR::Events::ActorTurnEvent, as: "actor" do  |e|
      actor = e.actor
      results = []
      action = nil 
      while action.nil? and actor.action_points > 0
        action = actor.last_action  = actor.last_action_this_tick = AR::Game::ExplorationMenu.new(actor).present
      end
      unless action.nil?
        results.push(AR::Events::ActionBeganEvent.new({performer: actor, action: action}))
      else
        actor.last_action_this_tick = AR::Game::WaitAction.new actor
      end
      results
    end
  end

  def self.choose_reaction
    AR::Events::Resolution.new event_class: AR::Events::DefenseChoice, as: "defender" do  |e|
      player = e.defender
      attacker = e.attacker
      results = []
      action =  AR::Game::ReactionMenu.new(player, attacker).present
      unless action.nil?
        results.push(AR::Events::ActionBeganEvent.new ({performer: player, action: action}))
      end
      results
    end
  end


  def print_stats!
    AR.put_s "\n"
    gauges_copy = Array.new self.gauges

    attribs = []
    attribs.push gauge("strength") 
    attribs.push gauge("dexterity") 
    attribs.push gauge("perception") 
    gauges_copy -= attribs

    AR.put_s "\n====Attributes===="
    attribs.each do |g|
      AR.print_s "#{g.name.capitalize}: #{g.modified_value}"
      exp_method = "#{g.name}_exp"
      if self.respond_to? exp_method 
        AR.print_s " - EXP: #{self.send(exp_method)}"
      end
      AR.print_s "\n"
    end

    resources = [] 
    resources.push gauge("health")
    resources.push gauge("action_points")
    resources.push gauge("hunger")
    gauges_copy -= resources 

    AR.put_s "---"
    resources.each do |g|
      AR.put_s "#{g.name.capitalize}: #{g.modified_value}/#{g.modified_max}"
    end


    unless self.all_equipped_ids.empty?
      AR.put_s "====Currently Equipped===="
      self.paper_doll.each  do |k, v|
        next if v.nil?
        AR.put_s "#{k.to_s.split("_").map(&:capitalize).join(" ")}: #{world.find(v).noun}"
      end
    end


    AR.put_s "\n====Offense===="
    offense = []

    offense.push (acc = gauge("accuracy"))
    offense.push (mel = gauge("melee_dmg_bonus"))
    offense.push (crit = gauge("critical_hit"))
    AR.put_s "#{acc.name}: #{acc.modified_value}"
    AR.put_s "#{mel.name}: #{mel.modified_value < 0 ? "-" : "+"}#{mel.modified_value}"
    AR.put_s "#{crit.name.split("_").map(&:capitalize).join(" ")}: #{crit.modified_value}%"
    gauges_copy -= offense 

    AR.put_s "---"
    AR.put_s "==Techniques=="
    AR.put_s "#{attack_techniques.map(&:name).join(" - ")}"


    AR.put_s "\n====Defense===="
    defense = []
    defense.push (av = gauge("avoidance"))
    defense.push (res = gauge("damage_resist"))
    gauges_copy -= defense 

    AR.put_s "#{av.name}: #{av.modified_value}"
    AR.put_s "#{res.name}: #{res.modified_value}"


    AR.put_s "---"
    AR.put_s "==Techniques=="
    AR.put_s "#{defense_techniques.map(&:name).join(" - ")}"

    unless gauges_copy.empty?
      AR.put_s "====Misc===="
      gauges_copy.each do |g|
        AR.put_s "#{g.name.capitalize}: #{g.modified_value}/#{g.modified_max}"
      end
    end

    AR.put_s "\n====Inventory===="
    unless inventory_item_ids.empty?
      AR.put_s "#{inventory_items.map(&:noun).join(" - ")}" 
    else
      AR.put_s "--empty--"
    end

    AR.put_s "\n====Perception===="
    unless known_object_ids.empty?
      AR.put_s "#{known_objects.map{|o| 
        if o.is_a? AR::Game::Character
        "#{o.name} (weak point counters: #{weak_points_for(o)})" 
        else
        "#{o.name}"
        end
      }.join(" - ")}" 
    else
      AR.put_s "--empty--"
    end


    AR.put_s("--Please scroll up unless Strength, Dexterity, and Perception Stats are visible--")


  end


end
