module AR::Game::Discoverable

  def self.init ar_object 

    ar_object.class.attr_serializeable :article, :definite_article,:noun, :discovery_threshold
    ar_object.discovery_threshold = 0
  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions << self.on_inspected
  end

  def self.on_inspected
    r =AR::Events::Resolution.new do |e|
      inspector = e.inspector 
      discoverable = e.discoverable
      e.engine.create(AR::Events::PerceptionAccountChangedEvent, ({perceiver: inspector, discoverable: discoverable, change: inspector.perception_lvl }))
    end
    r.as_who = "discoverable"
    r.event_class = AR::Events::DiscoverableInspectedEvent
    r
  end
 
  def name 
    definite = false
    if self.world and self.world.player 
      definite = self.world.player.has_known_about? self
    end

    if definite
      a = (self.definite_article rescue nil)
    else
      a = (self.article rescue nil)
    end

    a = definite ? "the" : "a" if a.nil?
    a = "an" if  (a == "a" and ['a', 'e', 'i', 'o', 'u', 'y'].include? self.noun[0])
    "#{a} #{self.noun}"
  end



end


