module AR
  module Game

    class Clearing < Scene 
      def initialize id=nil
        super 

        self.article = "this"
        self.noun = "clearing"

        self.add_story_implement DiscoveredImplement.new
        self.add_story_implement EnteredImplement.new
        self.add_story_implement InspectedImplement.new
      end
      
      class ClearingImplement < AR::Game::StoryBehavior::StoryImplement
      end

      class ClearingStory < AR::Game::StoryBehavior::Story
      end


      class EnteredImplement < ClearingImplement 
        def initialize stories=[]
          super
          s =  ClearingStory.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "This clearing is a sudden burst of tranquility, a sharp circle devoid of the suffocating trees." 
            else 
              ret = ""
            end
            
            ret 
          end
          add_story s
        end
      end

      class DiscoveredImplement < ClearingImplement
        def initialize stories = []
          super 
          story =  ClearingStory.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "The air hums with the buzzing of fireflies. For the first time all night, it is almost quiet."
            else 
              ret = ""
            end
            
            ret 
          end

          add_story story
        end
      end


      class InspectedImplement < ClearingImplement 
        def initialize stories=[]
          super
          s =  ClearingStory.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The ground, thick with grass, is beautifully lit by the moon, casting everything in a dreamlike sheen of blues and blacks."
            else 
              ret = ""
            end
            ret 
          end
          add_story s 
        end
      end







      
    end

  end
end
