module AR
  module Game

    class Scroll < Item
      def initialize id=nil
        super 
        self.noun = "scroll"
        self.article = "the"
        self.discovery_threshold = 5

        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end
      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "#{e.discovered.placement.capitalize}, you notice a folded up parchment."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            ret = "This must be the scroll that the old man was talking about.  As you unravel it, you can see bazaar, cryptic writing scribbled as one block."
          end
          add_story story


          #add stories like this:
          #s = Story.new when: AR::Events::Event, as: "participant" do |e|
          #end
          #add_story s
        end
      end

    end



  end
end
