module AR
  module Game

    class Plains < Scene
      def initialize id=nil
        super 

        #this is the last scene in skull embroidery
        self.noun = "plains"
        
        r = AR::Events::Resolution.new event_class: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|

          if e.enterer == e.engine.world.player
            necro =world.find("necromancers_assistant")

            res = []
            res.push(AR::Events::NarrationEvent.new narration: "Suddenly, the misty forest exit just in front of you spits out an armored, hideous man with greasy black hair down his shoulders.")
            res.push(AR::Events::ARObjectEnteredInhabitableEvent.new enterer: necro, inhabitable: self)
            e.engine.after_step AR::Events::DialogBeganEvent.new(player: e.engine.world.player, npc: necro)
            res
          end
        end
        self.resolutions.push r

        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "Exiting the enchanted forest, you come to a wide expanse of plains.  The dirt road that exits the forest runs West, and rolls over several shallow hills in the distance.  You can barely see a shoreline, where puffs of smoke float into the sky from a grouping of tiny-looking buildings.  It must be a coastal town of some kind.  You take one more glance behind you, at the forest.  A tongue of mist runs out of the forest's mouth."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "You are where the enchanted forest meets an expansive plains.  There is a small camp nearby, which looks recently used."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

        end
      end
    end




  end
end
