module AR
  
  module Game

    class NecromancersAssistant < Monster 
      def initialize id=nil
        super 

        self.noun = "bone-clad knight"
        self.unarmed_damage_dice = 8
        self.root_dialog_node_class = IntroNode
        add_story_implement StoryImplement.new

        after_gauges_init do |necromancer_assist|
          dex = necromancer_assist.gauge("dexterity")
          str = necromancer_assist.gauge("strength")
          per = necromancer_assist.gauge("perception")
          res = necromancer_assist.gauge("damage_resist")
          #basically gives him chitin armor value +1
          res.change_current_and_max 3
          dex.change_current_and_max 6 
          str.change_current_and_max 6
          per.change_current_and_max 6
          [str, dex, per].map(&:manual_child_sync) 
        end

        r = AR::Events::Resolution.new event_class: AR::Events::HitSuccess, as: "hitter" do |e|
          c = e.hitee
          all_poison_buffs = c.world.all_ar_objects.select{|o| o.class == AR::Game::PoisonBuff}
          on_this_char = all_poison_buffs.select{|pb| pb.character_id == c.id}
          chance = 50
          roll = rand(1..100)
          poisoned = roll <= chance

          if on_this_char.empty? and poisoned
            buff = PoisonBuff.new.subscribe!
            str = rand(1..2) 
            str *= 2 if e.is_critical
            buff.strength = str
            buff.character = c
            AR::Events::BuffApplied.new buff: buff, subject: c
          end
        end
        self.resolutions << r

        r = AR::Events::Resolution.new event_class: AR::Events::ARObjectDied, as: "ar_object" do |e|
          n="Somehow, you have managed to use your resources to escape the forest.  And now you are are left with a choice.  Will you pursue revenge with Death's Watch?  Or attempt to rejoin their apparently destructive order?  On the contrary, will you live a life of new found purity, and love?  Or will you dedicate your life to realize holy retribution for those you once served?"
          e1 = AR::Events::NarrationEvent.new narration: n

          n = "The choice will be yours.\nTo be continued..."
          e2 = AR::Events::NarrationEvent.new narration: n

          n = "Congratulations, you have managed to escape certain death within this forest!"
          e3 = AR::Events::NarrationEvent.new narration: n

          n = "It has been a huge pleasure, and learning experience creating this game for you.  I hope you enjoyed it.  Thanks so much for playing!"
          e4 = AR::Events::NarrationEvent.new narration: n


          creds = """
====CREDITS====
==Testers==
  Lindsay Handley
  Stephen Foster
  Josiah Paraiso
  Valerie Paraiso
  Jeron Paraiso
-------------

==Artwork==
  Josiah Paraiso
-------------

==Story Writers==
  Valerie Paraiso
  Jeron Paraiso
-------------

==Programmers==
  Jeron Paraiso
-------------

==Title ascii Art==
  http://patorjk.com
-------------
          """

          cred_ev = AR::Events::NarrationEvent.new narration: creds

          e5 = AR::Events::GameOverEvent.new

          [e1, e2, e3, e4, cred_ev, e5]
        end
        self.resolutions << r



      end#init

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          

          s = Story.new when: AR::Events::DiscoveryMadeEvent, as: "perceiver" do |e|
            p = e.perceiver
            d = e.discovered
            if d.is_a? AR::Game::Character and d != p
              "#{p.name.capitalize} is protected in the hardened remains of some magical beast or man, and undoubtedly given unholy resistance through dark ritual.  He draws a sword, made of a spinal cord turned rigid as rock, sharpened as a serrated sabre. The knight approaches you, and begins to speak."
            end
          end
          add_story s

          s = Story.new when: AR::Events::ActionBeganEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::AttackAction"
              "#{p.name.capitalize} lifts his sword for a strike."
            else
              ""
            end
          end
          add_story s


          s = Story.new when: AR::Events::ARObjectDied, as: "ar_object" do |e|
            "Battered and broken, #{e.ar_object.name.capitalize} kneels half prone to the ground, and coughs up a mass of blood.  He tries to resist gravity's inevitable pull with two quivering arms.  At last, he collapses in a maroon puddle in the grass."
          end
          add_story s

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The knight snarls at you with pure hate, sending an extra rush of adrenaline through your chest.  You examine him and find some weak points in the bone armor."
            else 
              ret = ""
            end
            ret 
          end
          add_story story




          s = Story.new when: AR::Events::ActionPerformedEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::AttackAction"
              "The knight swings at #{t.name} with his blade of bone."
            when "AR::Game::DefendAction"
              "#{p.name.capitalize} shuffles backward to avoid #{a.attacker.ownership} attack."
            else
              ""
            end
          end
          add_story s


          s = Story.new when: AR::Events::HitSuccess, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "#{h.name.capitalize}'s blade grinds into #{he.name}. #{he.name.capitalize} can feel a dark, treacherous disease infect the wound."
          end
          add_story s

          s = Story.new when: AR::Events::HitSuccess, as: "hitee" do |e|
            h = e.hitter
            he = e.hitee
            "#{he.name.capitalize} grunts in pain, holding the wound with his off-hand. His eyes dart toward you with more rage than before."

          end
          add_story s


          s = Story.new when: AR::Events::HitFailure, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "#{h.name.capitalize}'s blade misses #{he.name}."
          end
          add_story s

        end

      end

      #just to keep it easy on the fingers
      class DNode < AR::Game::NpcDialogBehavior::Node
      end

      class IntroNode < DNode
        def player_speech_event

        end

        def npc_speech_or_other_events

          narr = "\"Well, slather me in carrion cream and call me Cassey.  I've finally found you!  This forest has quite the sorcery stuck on it.  Every time I thought I knew where I was going, the god-forsaken thing spit me back out here again.  Not sure how you were able to get through.  Just my luck seeing you here, standing still like juicy prey.\" He points his bone sword at you with palpable anger, and shouts, \"Death's Watch has found you.  Draw your weapon, fool!\""

          AR::Events::NarrationEvent.new narration: narr
        end

        def initialize npc
          super
          loop_back_evt = AR::Events::DialogMenuPresented.new dialog_node: self
          who = DNode.new npc
          why = DNode.new npc
          what = DNode.new npc
          vio = DNode.new npc
          peace = DNode.new npc

          who.player_speech_event = player_speaks("Who are you?")
          who.npc_speech_or_other_events = [npc_speaks("I promise you this: I am your doom;  bone knight Trevin of Death's Watch.  Death sees all, brother.  He sees you and and I, and waits for you with open arms."), loop_back_evt]
          
          why.player_speech_event = player_speaks("Why are you looking for me?")
          why.npc_speech_or_other_events = [npc_speaks("Death's Watch has coughed you up, brother. Refusing to put your duty before your passion is shameful.  Phlegm of inaction had been gathering around you for some time, and ejection was, simply put, fate.    It is time to clean up the phlegm."), loop_back_evt]



          what.player_speech_event = player_speaks("What is \'Death\'s Watch\'?")
          what.npc_speech_or_other_events = [npc_speaks("We are enforcers for the earthen king, Death;  he is the lord of lifeless matter to which everything must return.  We are those who bear armor and weapon of bone, robes of black like the one you wear, and we cast pestilence upon life to return it to it's true state: dust.  You once were a powerful member of our order, but now you are soon to realize your true state.  How I shall enjoy my place this day.  Prepare to die!"), loop_back_evt]
          

          vio.player_speech_event = player_speaks("You will not take me before I skin you first!  Nyah!")
          vio.npc_speech_or_other_events = [npc_speaks("Perhaps you've changed since we casted you out.  No matter, you will die anyway! (He charges at you with his sword in hand)")] 

          peace.player_speech_event = player_speaks("Do we really need to resort to violence?  We can both live!")
          peace.npc_speech_or_other_events = [npc_speaks("Your ways only validate your death.  Life is an illusion; we are all but dust.  Die fool! (He charges at you with his sword in hand)")] 


          self.limbs = [who, why, what, vio, peace]
        end

      end


    end#spidey

  end#Game

end#AR
