module AR
  module Game

    class MoldyLog < Scene

      def initialize id=nil
        super 
        self.noun = "moldy log"
        self.discovery_threshold = 2
        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories = []
          super
          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "You see a moldy log, burrowed in rotting leaves, and sticks."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              "The hollow log looks very old, and blends in well with the forest floor, all mulchy and littered with mossy sticks and shrubbery. Where the log meets the ground there is a patch of red mushrooms growing."
            end
          end
          add_story story
        end
      end

    end



  end
end
