module AR
  module Game

    class MazePath < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "gateway"
        add_behavior Gateway
        add_story_implement StoryImplement.new
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The path twists around tightly grouped trees for about 10 ft, and disappears underneath the mist."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "You see #{e.discovered.name}"
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              if e.gateway.destination.class.to_s.include? "Maze" 
              ret = "Travelling through this misty forest, you occasionally run off the path, nearly running into a tree.  It feels that every step you take causes you to forget the way from which you've come."
              else 
                ret = "As you travel down the path, the mist fades, and you can once again feel the releiving rays of sun caress your skin."
              end
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end#Gateway class



  end#Game
end#AR
