module AR
  module Game

    class MazeForest < Scene
      def initialize id=nil
        super 

        self.noun = "misty forest"

        res = AR::Events::Resolution.new event_class: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|


          ent = e.enterer
          AR::Events::DiscoveryMadeEvent.new perceiver: ent, discovered: e.inhabitable
        end
        self.resolutions.push res

        

        spawner = AR::Events::Resolution.new event_class: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e| 
          g = e.gateway 
          roll = rand(1..100)
          chance = 50
          do_it = roll > chance
          AR.log("roll to spawn monster vs chance: #{roll}>#{chance}? #{do_it}")
          if do_it
          unless g.nil?
              m = GiantBeetle.new "#{self.id}_beetle_#{AR::Game::ARObject.gen_id}"
              m.subscribe!
              m.unarmed_damage_dice = 6
              init_gs = AR::Events::GaugesInitialized.new gauge_manager: m 
              init_gs.resolve!
              
              str  = m.gauge("strength")
              dex  = m.gauge("dexterity")
              perc = m.gauge("perception")

              
              str.change_current_and_max 4
              perc.change_current_and_max 3
              dex.change_current_and_max 3
              [str, perc, dex].map(&:manual_child_sync)
              

              e.engine.after_step AR::Events::ARObjectEnteredInhabitableEvent.new enterer: m, inhabitable: e.inhabitable, dont_narrate: true
              e.engine.after_step AR::Events::NarrationEvent.new narration: "You hear some movement behind a tree.  As you glance over, a giant beetle, which appears spinier and far larger than typical quickly darts into vision, ready to strike." 
              nil
          end
          end
        end
        self.resolutions.push(spawner)






        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            #these are good travelling narrations

            if e.enterer == e.engine.world.player
              ret = "You come to a crossroads in the misty forest.  All sense of Cardinal direction is lost, as the sun is completely obscured by the clouded atmosphere under the canopy you can only assume is assume is above you."
              
            else 
              ret = ""
            end
            ret 
          end
          add_story story
          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "An enchanting mist clouds your vision in every direction, and you can only see but a few yards around. Trees here line the path are extremely thick, and seem to be purposefully intimidating you."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

        end
      end
    end




  end
end
