module AR
  module Game

    class HardnessPotion < Item
      def initialize id=nil
        super 
        self.noun = "hardness potion"
        self.article = ""
        add_behavior AR::Game::Consumable
        self.on_consumed  = Proc.new do |consumer|
          #buff applied to increase dmg resist
          #+3 resistance, 4 duration
          buff = AR::Game::ResistanceBuff.new(3, 4).subscribe!
          subj = consumer.gauge("damage_resist")
          buff.on(subj)

          e1=AR::Events::NarrationEvent.new(narration: "You feel your skin harden like that of a beetle.")
          e2=AR::Events::BuffApplied.new buff: buff, subject: subj
          [e1,e2]
        end
        self.add_story_implement StoryImplement.new

      end

      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          #add stories like this:
          s = Story.new when: AR::Events::ItemConsumed, as: "item" do |e|
            if e.consumer == e.consumer.world.player
              "You drink the tarry, thick liquid.  The taste triggers your gag reflex, but you plug your nose and finish it off."
            end
          end
          add_story s
        end
      end


    end

  end
end
