module AR
  module Game

    class Forest01HiddenPathSouth < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "path through the ivy"
        add_behavior Gateway
        add_story_implement StoryImplement.new
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The hole in the wall of ivy leads to a hidden area in the forest."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "On the wall of ivy, you notice a dark cavity, which you may be able to travel through."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              ret = "You move the hanging vines and ivy out of the way and travel south."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end#Gateway class



  end#Game
end#AR
