module AR
  module Game

    class Chest < LootableThing
      def initialize id=nil
        super 
        self.noun = "rustic chest"
        #add_behavior AR::Game::SomeBehavior
        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories = []
          super
          s =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "In a dark corner of the cave, your torch reveals something rather exciting:  #{e.discovered.name} partly hidden by spider webs, and thick with dust."
            else 
              ret = ""
            end
            ret 
          end
          add_story s

          s = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              if e.discoverable.inventory_item_ids.empty?
                "You've already taken everything out of the chest."
              else
                "It's covered in dust.  Looks like it's been untouched for years."
              end
            end
          end
          add_story s

 
        end
      end

    end



  end
end
