class AR::Events::ExpLevelGained < AR::Events::Event
  attr_participant :leveler
  attr_participant :gauge
  attr_accessor :amount

  def initialize params
    super params
    self.amount = params[:amount]
  end 

  #story told by default if participants don't offer any story
  def default_story
    "Your #{gauge.name.capitalize} level has increased to #{gauge.modified_current + self.amount}!"
  end

  def resolve!
    AR::Events::GaugeChanged.new gauge: self.gauge, which: "current_and_max", amount: self.amount
  end 

end
