module AR::Game::Narrator 
  #add attr_accessor properties here... 

  def self.init ar_object
    ar_object.class.attr_serializeable :printer_id
    tmp_id = "narration_printer#{rand(1..10000)}"
    p = AR::Game::Printer.new tmp_id 
    p.char_drip_delay = 0.000 #seconds
    ar_object.printer = p
  end

  def printer=(p)
    self.printer_id = p.id
  end

  def printer
    ret = self.world.find printer_id 
    self.world.hook_in_object self if ret.nil?
    ret = self.world.find printer_id 
    raise "Error: can't hook in printer object" if ret.nil?
    ret
  end

  def self.extended ar_object
    self.init ar_object
  end 

  def narrate e
    narration = e.story
    unless narration == false
      dupl = narration.dup
      narration = AR::Events::Event.preprocess e, narration
      if narration.empty? 
        #attempt to get a default story of the event 
        narration = e.default_story
      end
    end

    
    unless narration.nil? or narration.empty? or (narration == false)
      printer.reprint_cache!

      printer.really_print "\n"
      printer.drip_print_s ("\n" + narration + " ")
      print "\n"
      self.world.events_engine.take_a_break!
    end
  end



end
