module AR
  module Game

    class BeetleJerky < Item
      def initialize id=nil
        super 
        self.noun = "roast insect meat"
        self.article = ""
        add_behavior AR::Game::Consumable
        self.on_consumed  = Proc.new do |consumer|
          g = consumer.gauge("hunger")
          am = -60
          AR::Events::GaugeChanged.new gauge: g, which: "current", gauge_owner: consumer, amount: am
        end
        add_story_implement StoryImplement.new
      end

      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          s = Story.new when: AR::Events::ItemConsumed, as: "item" do |e|
            if e.consumer == e.consumer.world.player
              "You chomp into the roasted insect meat.  It tastes way better than you expected, having a nutty chicken-like flavor."
            end
          end
          add_story s

        end
      end


    end

  end
end
