module AR
  module Game

    class Cave02HiddenPassageSouth < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "hidden passage south"
        add_behavior Gateway
        add_story_implement StoryImplement.new
        self.discovery_threshold = 10
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "You could climb the boulder and get through the chamber."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "On the south wall of the chamber, you see a hard-to-notice passage on embedded at top of a 5-foot boulder."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              ret = "After scaling the boulder you make your way through the passage.  It's a tunnel that seems to be man-made, as there are scrapes from a mining pick on all sides."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end#Gateway class



  end#Game
end#AR
